/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.task.standalone.commands;

import java.util.Map;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.ValidationStatus;
import org.nuxeo.connect.update.task.Command;
import org.nuxeo.connect.update.task.Task;
import org.nuxeo.connect.update.task.standalone.commands.AbstractCommand;
import org.nuxeo.connect.update.xml.XmlWriter;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.w3c.dom.Element;

public class Config
extends AbstractCommand {
    public static final String ID = "config";
    private String addtemplate;
    private String rmtemplate;
    private String set;

    public Config() {
        this(ID);
    }

    protected Config(String id) {
        super(id);
    }

    public void writeTo(XmlWriter writer) {
        writer.start(ID);
        if (this.addtemplate != null) {
            writer.attr("addtemplate", this.addtemplate);
        }
        if (this.rmtemplate != null) {
            writer.attr("rmtemplate", this.rmtemplate);
        }
        if (this.set != null) {
            writer.attr("set", this.set);
        }
        writer.end();
    }

    @Override
    protected Command doRun(Task task, Map<String, String> prefs) throws PackageException {
        Config rollback = new Config();
        ConfigurationGenerator cg = new ConfigurationGenerator();
        cg.init();
        try {
            if (this.addtemplate != null) {
                cg.addTemplate(this.addtemplate);
                rollback.rmtemplate = this.addtemplate;
            }
            if (this.rmtemplate != null) {
                cg.rmTemplate(this.rmtemplate);
                rollback.addtemplate = this.rmtemplate;
            }
            if (this.set != null) {
                String[] newValue = this.set.split("=", 2);
                String previousValue = cg.setProperty(newValue[0], newValue[1].length() > 0 ? newValue[1] : null);
                if (previousValue == null) {
                    previousValue = "";
                }
                rollback.set = newValue[0] + "=" + previousValue;
            }
        }
        catch (ConfigurationException e) {
            throw new PackageException((Throwable)e);
        }
        return rollback;
    }

    @Override
    protected void doValidate(Task task, ValidationStatus status) throws PackageException {
        if (this.addtemplate == null && this.rmtemplate == null && this.set == null) {
            status.addError("Cannot execute command in installer. Invalid config syntax: neither addtemplate, rmtemplate or set was specified.");
        }
        if (this.set != null && !this.set.contains("=")) {
            status.addError("Invalid config syntax: badly-formed property " + this.set);
        }
    }

    @Override
    public void readFrom(Element element) throws PackageException {
        String v = element.getAttribute("addtemplate");
        if (v.length() > 0) {
            this.addtemplate = v;
        }
        if ((v = element.getAttribute("rmtemplate")).length() > 0) {
            this.rmtemplate = v;
        }
        if ((v = element.getAttribute("set")).length() > 0) {
            this.set = v;
        }
    }
}

