/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.local.configuration;

import fr.toutatice.ecm.platform.core.local.configuration.WebConfsConfiguration;
import fr.toutatice.ecm.platform.core.local.configuration.WebConfsConfigurationAdapter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;

@Name(value="webConfsConfigurationActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class WebConfsConfigurationActions
implements Serializable {
    private static final long serialVersionUID = -3640808316766352674L;
    @In(create=true, required=true)
    protected transient CoreSession documentManager;

    public List<DocumentModel> getSelectedConfs(DocumentModel document) throws ClientException {
        ArrayList<DocumentModel> selectedWebConfs = new ArrayList<DocumentModel>(0);
        WebConfsConfiguration webConfsConfiguration = (WebConfsConfiguration)document.getAdapter(WebConfsConfiguration.class);
        if (webConfsConfiguration != null) {
            selectedWebConfs.addAll(webConfsConfiguration.getSelectedConfs(document));
        }
        return selectedWebConfs;
    }

    public List<DocumentModel> getNotSelectedConfs(DocumentModel document) throws ClientException {
        Boolean allDocsDenied;
        WebConfsConfiguration webConfsConfiguration;
        List<Object> notSelectedWebConfs = new ArrayList<DocumentModel>(0);
        if (document.hasFacet("WebConfigurationsLocalConfiguration") && (webConfsConfiguration = (WebConfsConfiguration)document.getAdapter(WebConfsConfiguration.class)) != null && BooleanUtils.isNotTrue((Boolean)(allDocsDenied = (Boolean)document.getPropertyValue("webconfs:denyAllConfsDocs")))) {
            List<String> allowedWebConfs = this.getAllowedWebConfs(document);
            notSelectedWebConfs = webConfsConfiguration.getAllGlobalWebConfs(document);
            for (String webConfCode : allowedWebConfs) {
                boolean found = false;
                Iterator<Object> iterator = notSelectedWebConfs.iterator();
                while (iterator.hasNext() && !found) {
                    DocumentModel globalWebConf = (DocumentModel)iterator.next();
                    String confCode = (String)((Object)globalWebConf.getPropertyValue("wconf:code"));
                    if (!StringUtils.isNotBlank((String)confCode) || !webConfCode.equals(confCode)) continue;
                    iterator.remove();
                    found = true;
                }
            }
        }
        return notSelectedWebConfs;
    }

    public List<String> getAllowedWebConfs(DocumentModel doc) throws ClientException {
        ArrayList<String> allowedWebConfs = new ArrayList<String>(0);
        WebConfsConfiguration webConfsConfiguration = (WebConfsConfiguration)doc.getAdapter(WebConfsConfiguration.class);
        if (webConfsConfiguration == null) {
            return Collections.emptyList();
        }
        allowedWebConfs.addAll(webConfsConfiguration.getAllowedWebConfs(doc));
        return allowedWebConfs;
    }

    public List<String> getGlobalWebconfsCodes() {
        ArrayList<String> gloablWebConfs = new ArrayList<String>(0);
        WebConfsConfigurationAdapter.UnrestrictedGetGlobalWebConfs globalConfsGetter = new WebConfsConfigurationAdapter.UnrestrictedGetGlobalWebConfs(this.documentManager);
        globalConfsGetter.runUnrestricted();
        DocumentModelList webConfs = globalConfsGetter.getWebConfs();
        if (webConfs != null && !webConfs.isEmpty()) {
            for (DocumentModel webConf : webConfs) {
                String code = (String)((Object)webConf.getPropertyValue("wconf:code"));
                gloablWebConfs.add(code);
            }
        }
        return gloablWebConfs;
    }
}

