/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.addons.toutapad.ecm.services;

import fr.toutatice.addons.toutapad.ecm.services.EtherpadClientService;
import fr.toutatice.addons.toutapad.ecm.services.EtherpadClientServiceDescriptor;
import fr.toutatice.addons.toutapad.ecm.services.EtherpadObject;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.etherpad_lite_client.EPLiteClient;
import org.etherpad_lite_client.EPLiteException;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.scheduler.Schedule;
import org.nuxeo.ecm.core.scheduler.SchedulerService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class EtherpadClientServiceImpl
extends DefaultComponent
implements EtherpadClientService {
    private static final Log log = LogFactory.getLog(EtherpadClientServiceImpl.class);
    private static final String EXTENSION_POINT_SERVER = "EtherpadServers";
    private Map<String, EtherpadClientServiceDescriptor> descriptors;
    private EPLiteClient client;
    private String serverName;

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        if (null == this.descriptors) {
            this.descriptors = new HashMap<String, EtherpadClientServiceDescriptor>();
        }
    }

    public void deactivate(ComponentContext context) throws Exception {
        super.deactivate(context);
        if (null != this.descriptors) {
            this.descriptors.clear();
        }
    }

    public void applicationStarted(ComponentContext context) throws Exception {
        super.applicationStarted(context);
        this.initializeEtherpadClient();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (EXTENSION_POINT_SERVER.equals(extensionPoint)) {
            log.debug((Object)("Toutapad: register contribution extension point = " + contributor.getName().getName()));
            EtherpadClientServiceDescriptor desc = (EtherpadClientServiceDescriptor)contribution;
            if (desc.isEnabled()) {
                this.descriptors.put(desc.getName(), desc);
                this.serverName = desc.getName();
                String cron = desc.getSynchronizationCron();
                if (StringUtils.isNotBlank((String)cron)) {
                    SchedulerService scheduler = (SchedulerService)Framework.getService(SchedulerService.class);
                    if (null != scheduler) {
                        scheduler.registerSchedule((Schedule)new ToutapadSchedule(desc.getName(), cron));
                    }
                } else {
                    log.warn((Object)"No synchronization cron is defined. It won't be any synchronization of Toutatice PADs together with the remote server PADs.");
                }
            }
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (EXTENSION_POINT_SERVER.equals(extensionPoint)) {
            log.debug((Object)("Toutapad: unregister contribution extension point = " + extensionPoint));
            EtherpadClientServiceDescriptor desc = (EtherpadClientServiceDescriptor)contribution;
            this.descriptors.remove(desc.getName());
        }
    }

    private EtherpadObject documentToPad(DocumentModel document) {
        String padId = document.getPropertyValue("ttc:webid").toString();
        HashMap mapres = this.getClient().createGroupIfNotExistsFor(padId);
        String groupId = (String)mapres.get("groupID");
        return new EtherpadObject(groupId, padId);
    }

    @Override
    public void createPAD(DocumentModel document) throws ClientException {
        EtherpadObject pad = this.documentToPad(document);
        try {
            String welcomeMessage = this.getDescriptor().getWelcomeMessage();
            welcomeMessage = URLEncoder.encode(welcomeMessage, "UTF-8");
            if (pad != null) {
                this.getClient().createGroupPad(pad.getGroupId(), pad.getPadId(), welcomeMessage);
            }
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)"Failed to set the default welcome message as defined whitin the configuration file");
        }
    }

    @Override
    public void copyPAD(DocumentModel from, DocumentModel to) throws ClientException {
        this.createPAD(to);
        EtherpadObject fromPad = this.documentToPad(from);
        EtherpadObject toPad = this.documentToPad(to);
        HashMap mapres = this.getClient().getHTML(fromPad.getGroupAndPadId());
        String html = (String)mapres.get("html");
        try {
            html = URLEncoder.encode(html, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.getClient().setHTML(toPad.getGroupAndPadId(), html);
    }

    @Override
    public void deletePAD(DocumentModel document) throws ClientException {
        EtherpadObject pad = this.documentToPad(document);
        this.getClient().deletePad(pad.getGroupAndPadId());
        this.getClient().deleteGroup(pad.getGroupId());
    }

    @Override
    public boolean isPADViewConnectedMode() throws ClientException {
        return this.getDescriptor().isConnectedView();
    }

    @Override
    public String getPADContent(DocumentModel document, String mimetype) throws EPLiteException {
        EtherpadObject pad = this.documentToPad(document);
        String content = "";
        if (mimetype.equals("html")) {
            HashMap map = this.getClient().getHTML(pad.getGroupAndPadId());
            content = (String)map.get("html");
        } else if (mimetype.equals("text")) {
            HashMap map = this.getClient().getText(pad.getGroupAndPadId());
            content = (String)map.get("text");
        } else {
            log.debug((Object)("Not support mimetype: " + mimetype));
        }
        return content;
    }

    @Override
    public String getPADURL(DocumentModel document, boolean authentified) throws EPLiteException {
        EtherpadObject pad = this.documentToPad(document);
        String padUrl = this.getDescriptor().getPublicServerURL() + this.getDescriptor().getPrefixURL() + pad.getGroupAndPadId();
        padUrl = padUrl.concat("?showControls=true&showChat=true&showLineNumbers=true&useMonospaceFont=false");
        if (authentified) {
            NuxeoPrincipal principal = (NuxeoPrincipal)document.getCoreSession().getPrincipal();
            padUrl = padUrl.concat(String.format("&userName=%s", principal.getFirstName() + " " + principal.getLastName()));
        }
        return padUrl;
    }

    @Override
    public String getPADReadOnlyURL(DocumentModel document) throws EPLiteException {
        EtherpadObject pad = this.documentToPad(document);
        HashMap map = this.getClient().getReadOnlyID(pad.getGroupAndPadId());
        String roID = (String)map.get("readOnlyID");
        String padUrl = this.getDescriptor().getPublicServerURL() + this.getDescriptor().getPrefixURL() + roID;
        return padUrl + "?noColors=true&showControls=false&showChat=false&showLineNumbers=false&useMonospaceFont=false";
    }

    private EtherpadClientServiceDescriptor getDescriptor() throws ClientException {
        if (StringUtils.isNotBlank((String)this.serverName)) {
            return this.descriptors.get(this.serverName);
        }
        throw new ClientException("No Etherpad server is defined and enabled from extension point 'EtherpadServers'");
    }

    private void initializeEtherpadClient() {
        this.client = new EPLiteClient(this.getDescriptor().getPrivateServerURL(), this.getDescriptor().getApiKey());
    }

    private EPLiteClient getClient() throws ClientException {
        if (null == this.client) {
            this.initializeEtherpadClient();
        }
        return this.client;
    }

    @Override
    public String grantAccess(CoreSession session, DocumentModel document) throws EPLiteException {
        NuxeoPrincipal principal = (NuxeoPrincipal)session.getPrincipal();
        HashMap mapres = this.client.createAuthorIfNotExistsFor(principal.getName(), principal.getFirstName() + " " + principal.getLastName());
        String authorId = (String)mapres.get("authorID");
        EtherpadObject pad = this.documentToPad(document);
        Calendar validUntil = Calendar.getInstance();
        validUntil.add(10, 2);
        mapres = this.client.createSession(pad.getGroupId(), authorId, validUntil.getTimeInMillis());
        String sessionId = (String)mapres.get("sessionID");
        return sessionId;
    }

    private class ToutapadSchedule
    implements Schedule {
        private static final long serialVersionUID = -4131912394687143207L;
        String id;
        String cron;

        public ToutapadSchedule(String id, String cron) {
            this.id = id;
            this.cron = cron;
        }

        public String getId() {
            return this.id;
        }

        public String getEventId() {
            return "toutaticePadEventSynchronize";
        }

        public String getEventCategory() {
            return null;
        }

        public String getCronExpression() {
            return this.cron;
        }

        public String getUsername() {
            return "admin";
        }

        public boolean isEnabled() {
            return true;
        }
    }
}

