/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.runners;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.api.Framework;
import org.osivia.migration.runners.AbstractRunner;

public class PortalSiteThumbnailRunner
extends AbstractRunner {
    private static final Log log = LogFactory.getLog(PortalSiteThumbnailRunner.class);
    private static final String LIVE_PSP_QUERY = "SELECT ecm:uuid FROM PortalSite WHERE ecm:isProxy = 0 AND ecm:isVersion = 0 AND ecm:currentLifeCycleState <> 'deleted' and ttcn:picture/data is not null and ttc:vignette/data is null";
    private static final AutomationService service = (AutomationService)Framework.getService(AutomationService.class);

    public PortalSiteThumbnailRunner(CoreSession session) {
        super(session);
    }

    @Override
    public int setInputs(int limit) {
        this.inputs = this.session.query(LIVE_PSP_QUERY, limit);
        this.inputs = this.removeDocsWithError(this.inputs);
        int size = this.inputs.size();
        this.totalInputs += size;
        return size;
    }

    @Override
    public void run() throws ClientException {
        for (DocumentModel ps : this.inputs) {
            try {
                DocumentModel treatedPs = this.resizePictureToThumbnail(ps);
                if (treatedPs == null) continue;
                this.session.saveDocument(treatedPs);
                String liveVersionLabel = ps.getVersionLabel();
                DocumentModel proxy = ToutaticeDocumentHelper.getProxy((CoreSession)this.session, (DocumentModel)treatedPs, null);
                if (proxy != null) {
                    String proxyVersionLabel = proxy.getVersionLabel();
                    if (StringUtils.equals((String)liveVersionLabel, (String)proxyVersionLabel)) {
                        this.setOnLine(treatedPs);
                    } else {
                        log.debug((Object)String.format("Treating last version of [%s]...", treatedPs.getPathAsString()));
                        DocumentModel latestVersion = ToutaticeDocumentHelper.getLatestDocumentVersion((DocumentModel)ps, (CoreSession)this.session);
                        if (latestVersion != null) {
                            latestVersion.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
                            latestVersion = this.resizePictureToThumbnail(latestVersion);
                            this.session.saveDocument(latestVersion);
                        } else {
                            log.warn((Object)String.format("PortalSite [%s] is in incoherent state: published but has no latest version", treatedPs.getPathAsString()));
                        }
                    }
                }
                this.session.save();
            }
            catch (Exception e) {
                docsOnError.add(ps.getId());
                throw new ClientException((Throwable)e);
            }
        }
    }

    protected DocumentModel resizePictureToThumbnail(DocumentModel ps) {
        DocumentModel res = null;
        OperationContext ctx = new OperationContext(this.session);
        ctx.setInput((Object)ps);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("img_heidth", 100);
        params.put("img_width", 100);
        params.put("xpath_img_in", "ttcn:picture");
        params.put("xpath_img_out", "ttc:vignette");
        params.put("enlarge", true);
        try {
            res = (DocumentModel)service.run(ctx, "ImageResize.Operation", params);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        return res;
    }

    protected void setOnLine(DocumentModel treatedPs) {
        OperationContext ctx = new OperationContext(this.session);
        ctx.setInput((Object)treatedPs);
        HashMap params = new HashMap();
        try {
            service.run(ctx, "Document.SetOnLineOperation", params);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }
}

