/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.migration.runners;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;
import org.nuxeo.runtime.api.Framework;
import org.osivia.migration.runners.AbstractRunner;

public class ThumbnailPictureRunner
extends AbstractRunner {
    private static final Log log = LogFactory.getLog(ThumbnailPictureRunner.class);
    private static String PICT_MISSING_THUMB_VIEW_QUERY = "select * from Picture where ecm:isProxy = 0 and (file:content/data is not null or picture:views/1/content/data is not null) and (picture:views/4/content/data is null)";
    private static final String DOT = ".";
    private static final String WORD_SEPARATOR = "-";
    protected static final String FILE_CONTENT_XPATH = "file:content";
    protected static final String FILENAME_XPATH = "file:filename";
    protected static final String VIEWS_PROPERTY = "picture:views";
    protected static final String VIEW_XPATH_FILENAME = "picture:views/1/filename";
    protected static final String VIEW_XPATH_CONTENT = "picture:views/1/content";
    protected static final int NB_VIEWS = 5;
    private static final String ORIGINAL = "Original_";
    private static ImagingService imagingService;
    private static MimetypeRegistry mtRegistry;

    protected static MimetypeRegistry getMimeTypeRegistry() {
        if (mtRegistry == null) {
            mtRegistry = (MimetypeRegistry)Framework.getService(MimetypeRegistry.class);
        }
        return mtRegistry;
    }

    protected static ImagingService getImagingService() {
        if (imagingService == null) {
            imagingService = (ImagingService)Framework.getService(ImagingService.class);
        }
        return imagingService;
    }

    public ThumbnailPictureRunner(CoreSession session) {
        super(session);
    }

    @Override
    public int setInputs(int limit) {
        int size = 0;
        this.inputs = this.session.query(PICT_MISSING_THUMB_VIEW_QUERY, limit);
        this.inputs = this.removeDocsWithError(this.inputs);
        size = this.inputs.size();
        this.totalInputs += size;
        return size;
    }

    @Override
    public void run() throws ClientException {
        for (DocumentModel picture : this.inputs) {
            try {
                this.fillThumbnailView(picture);
            }
            catch (IOException | ClientException e) {
                docsOnError.add(picture.getId());
                throw new ClientException(e);
            }
            this.session.save();
        }
    }

    private Blob fillThumbnailView(DocumentModel picture) throws ClientException, IOException {
        Property fileProp;
        Blob blob;
        PictureResourceAdapter pictureAdapter = (PictureResourceAdapter)picture.getAdapter(PictureResourceAdapter.class);
        String fileName = null;
        if (log.isTraceEnabled() && picture != null) {
            String version = picture.isVersion() ? " -- V " + picture.getVersionLabel() : "";
            log.trace((Object)("Treating picture: " + picture.getPathAsString() + version));
        }
        if ((blob = (Blob)(fileProp = picture.getProperty(FILE_CONTENT_XPATH)).getValue()) == null) {
            fileProp = picture.getProperty(VIEW_XPATH_CONTENT);
            blob = (Blob)fileProp.getValue();
            if (blob.getLength() <= 0L) {
                throw new ClientException(picture.getPathAsString() + " not treated: blob's length is 0");
            }
            fileName = this.getFileNameFromOrgView(blob, picture);
            blob.setFilename(fileName);
            fileProp.setValue((Object)blob);
            picture.setPropertyValue(FILE_CONTENT_XPATH, (Serializable)blob);
            picture.setPropertyValue(FILENAME_XPATH, (Serializable)((Object)fileName));
        } else {
            if (blob.getLength() <= 0L) {
                throw new ClientException(picture.getPathAsString() + " not treated: blob's length is 0");
            }
            fileName = this.getFileNameFromContent(picture, blob);
            if (!StringUtils.equals((String)blob.getFilename(), (String)fileName)) {
                blob.setFilename(fileName);
                picture.setPropertyValue(FILENAME_XPATH, (Serializable)((Object)fileName));
            }
        }
        boolean done = pictureAdapter.fillPictureViews(blob, fileName, picture.getTitle(), null);
        if (!done) {
            throw new ClientException(picture.getPathAsString() + " not treated: unknown error");
        }
        this.checkTreatment(pictureAdapter, picture);
        if (picture.isVersion()) {
            picture.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
        }
        this.session.saveDocument(picture);
        ++this.treatedInputs;
        return blob;
    }

    protected String getFileNameFromContent(DocumentModel picture, Blob blob) {
        String fileName = blob.getFilename();
        if (StringUtils.isBlank((String)fileName) && StringUtils.isBlank((String)(fileName = (String)((Object)picture.getPropertyValue(FILENAME_XPATH))))) {
            fileName = this.generateFileName(picture, blob);
        }
        return fileName;
    }

    protected String generateFileName(DocumentModel picture, Blob blob) {
        String fileName = picture.getTitle();
        if (StringUtils.contains((String)fileName, (String)DOT)) {
            String[] parts = StringUtils.split((String)fileName, (String)DOT);
            fileName = IdUtils.generateId((String)parts[0], (String)WORD_SEPARATOR, (boolean)true, (int)30) + DOT + IdUtils.generateId((String)parts[1], (String)WORD_SEPARATOR, (boolean)true, (int)4);
        } else {
            List extensions = ThumbnailPictureRunner.getMimeTypeRegistry().getExtensionsFromMimetypeName(blob.getMimeType());
            if (extensions.size() > 0) {
                fileName = IdUtils.generateId((String)picture.getTitle(), (String)WORD_SEPARATOR, (boolean)true, (int)30) + DOT + (String)extensions.get(0);
            } else {
                throw new ClientException(picture.getPathAsString() + " not treated: mime-type not found");
            }
        }
        return fileName;
    }

    private void checkTreatment(PictureResourceAdapter pictureAdapter, DocumentModel picture) throws ClientException {
        ListProperty views = (ListProperty)picture.getProperty(VIEWS_PROPERTY);
        if (views.size() < 5) {
            throw new ClientException(picture.getPathAsString() + " not treated");
        }
    }

    protected String getFileNameFromOrgView(Blob blob, DocumentModel picture) throws ClientException {
        String fileName = blob.getFilename();
        if (StringUtils.isNotBlank((String)fileName)) {
            fileName = StringUtils.startsWith((String)fileName, (String)ORIGINAL) ? StringUtils.substringAfter((String)fileName, (String)ORIGINAL) : fileName;
        } else {
            fileName = (String)((Object)picture.getPropertyValue(VIEW_XPATH_FILENAME));
            String string = fileName = StringUtils.startsWith((String)fileName, (String)ORIGINAL) ? StringUtils.substringAfter((String)fileName, (String)ORIGINAL) : fileName;
            if (StringUtils.isBlank((String)fileName)) {
                fileName = this.generateFileName(picture, blob);
            }
        }
        return fileName;
    }
}

