/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation;

import fr.toutatice.ecm.platform.core.helper.ToutaticeSilentProcessRunnerHelper;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.annotations.In;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.versioning.VersioningService;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

@Operation(id="Document.SetWebId", category="Document", label="Set webid.", description="Check unicity of webid and apply to the document in current domain..")
public class SetWebID {
    public static final String ID = "Document.SetWebId";
    public static final int BYTES = 8;
    private static final Log log = LogFactory.getLog(SetWebID.class);
    private static final String NO_RECURSIVE_CHAIN = "notRecursive";
    private static final List<Class<?>> FILTERED_SERVICES_LIST = new ArrayList<Class<?>>(){
        private static final long serialVersionUID = 1L;
        {
            this.add(EventService.class);
            this.add(VersioningService.class);
        }
    };
    @Context
    protected CoreSession coreSession;
    @In(create=true)
    protected NavigationContext navigationContext;
    @Deprecated
    @Param(name="chainSource", required=false)
    protected String chainSource;

    @OperationMethod
    public DocumentModel run(DocumentModel document) throws Exception {
        UnrestrictedSilentSetWebIdRunner runner = new UnrestrictedSilentSetWebIdRunner(this.coreSession, document, this.chainSource);
        runner.silentRun(true, FILTERED_SERVICES_LIST);
        return runner.getDocument();
    }

    public static class UnrestrictedSilentSetWebIdRunner
    extends ToutaticeSilentProcessRunnerHelper {
        private DocumentModel document;
        private String chainSource;
        private DocumentModel parentDoc;

        protected UnrestrictedSilentSetWebIdRunner(CoreSession session, DocumentModel document, String chainSource) {
            super(session);
            this.document = document;
            this.chainSource = chainSource;
        }

        public DocumentModel getDocument() {
            return this.parentDoc != null ? this.parentDoc : this.document;
        }

        public void run() throws ClientException {
            String webId = null;
            String extension = null;
            boolean creationMode = false;
            boolean hasToBeUpdated = false;
            if (this.document.isImmutable() || !this.document.hasSchema("toutatice")) {
                return;
            }
            if (StringUtils.isBlank((String)this.getWebId())) {
                webId = this.generateWebId(webId);
                extension = this.getBlobExtensionIfExists(webId);
                webId = this.removeBlobExtensionIfExists(webId, extension);
                creationMode = true;
            } else if (StringUtils.isNotBlank((String)this.getWebId())) {
                webId = this.getWebId().toString();
                if (StringUtils.contains((String)webId, (String)"_")) {
                    String nonTechPart = StringUtils.substringAfterLast((String)webId, (String)"_");
                    String techPart = StringUtils.substringBeforeLast((String)webId, (String)"_");
                    webId = techPart.concat("_").concat(IdUtils.generateId((String)nonTechPart, (String)"-", (boolean)true, (int)512));
                } else {
                    webId = IdUtils.generateId((String)webId, (String)"-", (boolean)true, (int)512);
                }
            }
            String originalWebid = webId;
            while (UnrestrictedSilentSetWebIdRunner.isNotUnique(this.session, this.document, webId)) {
                webId = this.generateWebId(originalWebid);
                hasToBeUpdated = true;
            }
            if (StringUtils.isNotBlank((String)webId) && (hasToBeUpdated || !hasToBeUpdated && creationMode)) {
                log.info((Object)("Id relocated to " + webId + " for document " + this.document.getPathAsString()));
                this.document.setPropertyValue("ttc:webid", (Serializable)((Object)webId));
                if (extension != null) {
                    this.document.setPropertyValue("ttc:extensionUrl", (Serializable)((Object)extension));
                }
                this.session.saveDocument(this.document);
            }
        }

        protected String getWebId() {
            return (String)((Object)this.document.getPropertyValue("ttc:webid"));
        }

        protected String generateWebId(String webId) {
            if (StringUtils.isBlank((String)webId)) {
                String[] arrayPath = this.document.getPathAsString().split("/");
                webId = arrayPath[arrayPath.length - 1];
                if (webId.contains(".")) {
                    webId = webId.substring(0, webId.indexOf("."));
                }
            } else {
                webId = webId.concat("-".concat(this.generateBase62()));
            }
            return webId;
        }

        private String generateBase62() {
            int size = 6;
            long random = 0L;
            for (int i = 0; i < size; ++i) {
                int value = RandomUtils.nextInt((int)61);
                random += (long)value * Math.round(Math.pow(64.0, i));
            }
            ByteBuffer buffer = ByteBuffer.allocate(8);
            buffer.putLong(0, random);
            byte[] bytes = buffer.array();
            byte[] truncatedArray = new byte[size];
            for (int i = 0; i < size; ++i) {
                truncatedArray[i] = bytes[8 - size + i];
            }
            String encodedString = Base64.encodeBase64String((byte[])truncatedArray);
            return StringUtils.removeStart((String)encodedString, (String)"AA");
        }

        protected String getBlobExtensionIfExists(String webid) {
            int lastIndexOf;
            String extension = null;
            if (("File".equals(this.document.getType()) || "Picture".equals(this.document.getType())) && (lastIndexOf = this.document.getTitle().lastIndexOf(".")) > -1) {
                extension = this.document.getTitle().substring(lastIndexOf + 1, this.document.getTitle().length());
            }
            return extension;
        }

        protected String removeBlobExtensionIfExists(String webid, String extension) {
            if (StringUtils.isNotBlank((String)extension) && webid.endsWith(extension)) {
                webid = webid.substring(0, webid.length() - extension.length() - 1);
            }
            return webid;
        }

        public static boolean isNotUnique(CoreSession session, DocumentModel document, String webId) {
            String escapedWebId = StringEscapeUtils.escapeJava((String)webId);
            DocumentModelList query = session.query(String.format("select * from Document where ttc:webid = '%s' AND ecm:isVersion = 0 AND ecm:uuid <> '%s'  and ecm:isProxy = 0 ", escapedWebId, document.getId()));
            return query.size() > 0;
        }
    }
}

