/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.document;

import fr.toutatice.ecm.platform.automation.document.AbstractDublinCoreDocumentUpdate;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.io.IOException;
import org.nuxeo.ecm.automation.ConflictOperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Document.TTCUpdate")
public class UpdateDocument
extends AbstractDublinCoreDocumentUpdate {
    public static final String ID = "Document.TTCUpdate";
    @Context
    protected CoreSession session;
    @Param(name="properties")
    protected Properties properties;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;
    @Param(name="changeToken", required=false)
    protected String changeToken = null;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        String repoToken;
        DocumentModel updatedDoc = doc;
        if (this.changeToken != null && !this.changeToken.equals(repoToken = doc.getChangeToken())) {
            throw new ConflictOperationException(doc);
        }
        updatedDoc = this.properties != null ? super.executeSplittingProperties(this.session, doc, this.properties, this.save) : this.execute(this.session, doc, this.properties, this.save);
        return updatedDoc;
    }

    @Override
    protected DocumentModel execute(CoreSession session, DocumentModel document, Properties properties, boolean save) throws ClientException, IOException {
        DocumentHelper.setProperties((CoreSession)session, (DocumentModel)document, (Properties)properties);
        if (save) {
            document = session.saveDocument(document);
        }
        return document;
    }

    @Override
    protected DocumentModel execute(CoreSession session, DocumentModel document, Properties properties, Properties dublinCoreProperties, boolean save) throws ClientException, IOException {
        DocumentHelper.setProperties((CoreSession)session, (DocumentModel)document, (Properties)properties);
        DocumentModel updatedDocument = document;
        if (save) {
            updatedDocument = session.saveDocument(document);
        }
        DocumentHelper.setProperties((CoreSession)session, (DocumentModel)updatedDocument, (Properties)dublinCoreProperties);
        if (save) {
            ToutaticeDocumentHelper.saveDocumentSilently((CoreSession)session, (DocumentModel)updatedDocument, (boolean)false);
        }
        return updatedDocument;
    }
}

