/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.automation.transaction;

import fr.toutatice.ecm.platform.automation.transaction.io.PreMessageBodyWriter;
import java.security.Principal;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.core.api.local.LoginStack;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.jtajca.NuxeoContainer;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class TransactionalConversation
implements Callable<Object> {
    private static final Log log = LogFactory.getLog(TransactionalConversation.class);
    public static final String NOT_FILLED = "Not_filled";
    private ExecutorService executor;
    private Principal principal;
    private String repositoryName;
    private Transaction tx;
    private CoreSession session;
    private AutomationService opSrv;
    private OperationContext opCtx;
    private String opId;
    private Map<String, Object> params;
    private String txcId;
    private LoginStack.Entry loginStack;
    private boolean start = true;

    public TransactionalConversation(Principal principal, String repositoryName, ExecutorService executor, LoginStack.Entry loginStack) {
        this.principal = principal;
        this.repositoryName = repositoryName;
        this.executor = executor;
        this.loginStack = loginStack;
        this.opSrv = (AutomationService)Framework.getService(AutomationService.class);
    }

    @Override
    public Object call() throws Exception {
        Object result = null;
        if (this.start) {
            this.open(this.principal, this.repositoryName);
            ClientLoginModule.clearThreadLocalLogin();
            if (this.loginStack != null) {
                ClientLoginModule.getThreadLocalLogin().push(this.loginStack.getPrincipal(), (Object)this.loginStack.getPrincipal(), this.loginStack.getSubject());
            }
            this.start = false;
        } else if (StringUtils.equals((String)"Repository.CommitOrRollbackTransaction", (String)this.opId)) {
            this.saveNClose();
        } else {
            try {
                if (StringUtils.isNotBlank((String)this.opId)) {
                    OperationContext ctx = new OperationContext(this.session);
                    ctx.setInput(this.opCtx.getInput());
                    ctx.setCommit(false);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Executing in transaction " + this.getTxcId()));
                    }
                    if (!StringUtils.equals((String)"Repository.MarkTransactionAsRollback", (String)this.opId)) {
                        result = this.opSrv.run(ctx, this.opId, this.params);
                        PreMessageBodyWriter.prepareResult(result);
                    } else {
                        TransactionHelper.setTransactionRollbackOnly();
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Exception in transaction :" + e));
                e.printStackTrace();
                throw e;
            }
        }
        return result;
    }

    public void open(Principal principal, String repositoryName) throws SystemException {
        this.open(principal, repositoryName, -1);
    }

    public void open(Principal principal, String repositoryName, int txTimeout) throws SystemException {
        if (txTimeout == -1) {
            TransactionHelper.startTransaction();
        } else {
            TransactionHelper.startTransaction((int)txTimeout);
        }
        this.tx = NuxeoContainer.getTransactionManager().getTransaction();
        this.session = CoreInstance.openCoreSession((String)repositoryName, (Principal)principal);
    }

    public void saveNClose() {
        if (this.session != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Saving session");
            }
            this.session.save();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Session saved");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)"Closing session");
            }
            this.session.close();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Session closed");
            }
        }
        if (this.tx != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Commiting or rollbacking transaction");
            }
            TransactionHelper.commitOrRollbackTransaction();
            if (log.isDebugEnabled()) {
                log.debug((Object)"Transaction commit or rollback");
            }
        }
    }

    public synchronized void setOperationId(String opId) {
        this.opId = opId;
    }

    public synchronized void setOperationContext(OperationContext operationCtx) {
        this.opCtx = operationCtx;
    }

    public synchronized void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public String getTxcId() {
        return this.txcId;
    }

    public void setTxcId(String txcId) {
        this.txcId = txcId;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }
}

