/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.url;

import fr.toutatice.ecm.platform.core.helper.ToutaticeQueryHelper;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;

public class WebIdResolver {
    private static final Log log = LogFactory.getLog(WebIdResolver.class);

    private WebIdResolver() {
    }

    public static DocumentModel getLiveDocumentByWebId(CoreSession coreSession, String webId) {
        DocumentModel live = null;
        String query = String.format("select * from Document where ttc:webid = '%s' AND ecm:isVersion = 0 and ecm:isProxy = 0 ", webId);
        DocumentModelList lives = ToutaticeQueryHelper.queryUnrestricted((CoreSession)coreSession, (String)query);
        if (CollectionUtils.isNotEmpty((Collection)lives) && lives.size() == 1) {
            live = (DocumentModel)lives.get(0);
        }
        return live;
    }

    public static DocumentModelList getDocumentsByWebId(CoreSession coreSession, String webId) throws NoSuchDocumentException {
        DocumentModelList documents = null;
        if (StringUtils.isNotBlank((String)webId)) {
            long begin = System.currentTimeMillis();
            UnrestrictedFecthWebIdRunner fecthWebIdRunner = new UnrestrictedFecthWebIdRunner(coreSession, webId);
            fecthWebIdRunner.runUnrestricted();
            documents = fecthWebIdRunner.getDocuments();
            if (log.isTraceEnabled()) {
                long end = System.currentTimeMillis();
                log.trace((Object)(": " + String.valueOf(end - begin) + " ms"));
            }
            if (CollectionUtils.isEmpty((Collection)documents) || CollectionUtils.isNotEmpty((Collection)documents) && documents.size() > 1) {
                throw new NoSuchDocumentException(webId);
            }
        }
        return documents;
    }

    private static class UnrestrictedFecthWebIdRunner
    extends UnrestrictedSessionRunner {
        String webId;
        DocumentModelList documents;

        public UnrestrictedFecthWebIdRunner(CoreSession session, String webId) {
            super(session);
            this.webId = webId;
            this.documents = new DocumentModelListImpl();
        }

        public void run() throws ClientException {
            this.getLive();
        }

        private void getLive() {
            DocumentModelList lives = this.session.query(String.format("select * from Document where ttc:webid = '%s' AND ecm:isVersion = 0 and ecm:isProxy = 0 ", this.webId));
            if (CollectionUtils.isNotEmpty((Collection)lives) && lives.size() == 1) {
                this.documents.add(lives.get(0));
            }
        }

        public DocumentModelList getDocuments() {
            return this.documents;
        }
    }
}

