/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.url;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.service.url.WebIdRef;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;

public class ToutaticeDocumentLocation
extends DocumentLocationImpl {
    private static final long serialVersionUID = -1632965927936780332L;
    private static final Log log = LogFactory.getLog(ToutaticeDocumentLocation.class);
    private String serverName;
    private WebIdRef webIdRef;

    public String getServerName() {
        return this.serverName;
    }

    public WebIdRef getWebIdRef() {
        return this.webIdRef;
    }

    public ToutaticeDocumentLocation(String serverName, WebIdRef docRef) {
        super(serverName, (DocumentRef)docRef);
        this.serverName = serverName;
        this.webIdRef = docRef;
    }

    public ToutaticeDocumentLocation(DocumentModel doc) {
        super(doc);
        try {
            String webId = ToutaticeDocumentLocation.getLogicalWebId(doc);
            String explicitUrl = (String)((Object)doc.getPropertyValue("ttc:explicitUrl"));
            String extensionUrl = (String)((Object)doc.getPropertyValue("ttc:extensionUrl"));
            this.webIdRef = new WebIdRef(explicitUrl, webId, extensionUrl);
        }
        catch (Exception e) {
            log.error((Object)("Can not get webId property: " + e.getMessage()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getLogicalWebId(DocumentModel doc) throws Exception {
        String wId = (String)((Object)doc.getPropertyValue("ttc:webid"));
        if (wId == null) return wId;
        if (!doc.isProxy()) return wId;
        if (!doc.hasFacet("isRemoteProxy")) return wId;
        DocumentModel parent = ToutaticeDocumentHelper.getUnrestrictedParent((DocumentModel)doc);
        if (parent != null) {
            String pWId = (String)((Object)parent.getPropertyValue("ttc:webid"));
            if (pWId == null) throw new Exception("Document " + parent.getPathAsString() + " has no webId.");
            return wId.concat("_c_").concat(pWId);
        }
        log.warn((Object)("Document " + doc.getPathAsString() + " has no parent"));
        return wId;
    }
}

