/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.url;

import fr.toutatice.ecm.platform.service.url.WebIdRef;
import fr.toutatice.ecm.platform.service.url.WebIdResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentSecurityException;
import org.nuxeo.ecm.core.model.NoSuchDocumentException;

public class ToutaticeDocumentResolver {
    private static final Log log = LogFactory.getLog(ToutaticeDocumentResolver.class);

    private ToutaticeDocumentResolver() {
    }

    public static DocumentModelList resolveReference(CoreSession session, WebIdRef webIdRef) throws DocumentException, ClientException {
        if (webIdRef == null) {
            throw new DocumentException("Invalid reference (null)");
        }
        Object ref = webIdRef.reference();
        if (ref == null) {
            throw new DocumentException("Invalid reference (null)");
        }
        return ToutaticeDocumentResolver.resolveDocumentByWebId(session, webIdRef);
    }

    protected static DocumentModelList resolveDocumentByWebId(CoreSession session, WebIdRef webIdRef) throws ClientException {
        String webId = (String)webIdRef.reference();
        DocumentModelList documents = null;
        try {
            documents = WebIdResolver.getDocumentsByWebId(session, webId);
        }
        catch (NoSuchDocumentException de) {
            throw new ClientException((Throwable)de);
        }
        return documents;
    }

    protected static final void checkPermission(CoreSession session, DocumentModel doc, String permission) throws DocumentException, ClientException {
        if (doc != null && !session.hasPermission(doc.getRef(), permission)) {
            throw new DocumentSecurityException("Privilege '" + permission + "' is not granted to '" + session.getPrincipal().getName() + "'");
        }
    }
}

