/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.userservices;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.international.StatusMessage;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.webapp.clipboard.ClipboardActionsBean;

@Name(value="clipboardActions")
@Scope(value=ScopeType.SESSION)
@Install(precedence=31)
public class ToutaticeClipboardActionsBean
extends ClipboardActionsBean {
    private static final long serialVersionUID = 7075230311269912496L;
    private static final Log log = LogFactory.getLog(ToutaticeClipboardActionsBean.class);
    @In(create=true)
    protected transient DocumentRoutingService routingService;

    public boolean getCanMoveInside(String listName, DocumentModel document) throws ClientException {
        if (this.documentsListsManager.isWorkingListEmpty(listName) || document == null) {
            return false;
        }
        DocumentRef destFolderRef = document.getRef();
        DocumentModel destFolder = document;
        if (!this.documentManager.hasPermission(destFolderRef, "AddChildren")) {
            return false;
        }
        for (DocumentModel docModel : this.documentsListsManager.getWorkingList(listName)) {
            DocumentRef sourceFolderRef = docModel.getParentRef();
            String sourceType = docModel.getType();
            boolean canRemoveDoc = this.documentManager.hasPermission(sourceFolderRef, "RemoveChildren");
            boolean canPasteInCurrentFolder = this.typeManager.isAllowedSubType(sourceType, destFolder.getType(), this.navigationContext.getCurrentDocument());
            boolean sameFolder = sourceFolderRef.equals(destFolderRef);
            boolean hasActiveWF = false;
            List documentRoutes = this.routingService.getDocumentRoutesForAttachedDocument(this.documentManager, docModel.getId());
            if (documentRoutes != null && !documentRoutes.isEmpty()) {
                hasActiveWF = true;
            }
            if (!canRemoveDoc || !canPasteInCurrentFolder || sameFolder || hasActiveWF) continue;
            return true;
        }
        return false;
    }

    public List<DocumentModel> moveDocumentsToNewParent(DocumentModel destFolder, List<DocumentModel> docs) throws ClientException {
        DocumentRef destFolderRef = destFolder.getRef();
        boolean destinationIsDeleted = "deleted".equals(destFolder.getCurrentLifeCycleState());
        ArrayList<DocumentModel> newDocs = new ArrayList<DocumentModel>();
        StringBuilder sb = new StringBuilder();
        for (DocumentModel docModel : docs) {
            DocumentModel newDoc;
            DocumentRef sourceFolderRef = docModel.getParentRef();
            String sourceType = docModel.getType();
            boolean canRemoveDoc = this.documentManager.hasPermission(sourceFolderRef, "RemoveChildren");
            boolean canPasteInCurrentFolder = this.typeManager.isAllowedSubType(sourceType, destFolder.getType(), this.navigationContext.getCurrentDocument());
            boolean sameFolder = sourceFolderRef.equals(destFolderRef);
            boolean hasActiveWF = false;
            List documentRoutes = this.routingService.getDocumentRoutesForAttachedDocument(this.documentManager, docModel.getId());
            if (documentRoutes != null && !documentRoutes.isEmpty()) {
                hasActiveWF = true;
            }
            if (!canRemoveDoc || !canPasteInCurrentFolder || sameFolder || hasActiveWF) continue;
            if (destinationIsDeleted) {
                if (this.checkDeletedState(docModel)) {
                    newDoc = this.documentManager.move(docModel.getRef(), destFolderRef, null);
                    this.setDeleteState(newDoc);
                    newDocs.add(newDoc);
                    continue;
                }
                this.addWarnMessage(sb, docModel);
                continue;
            }
            newDoc = this.documentManager.move(docModel.getRef(), destFolderRef, null);
            newDocs.add(newDoc);
        }
        this.documentManager.save();
        if (sb.length() > 0) {
            this.facesMessages.add(StatusMessage.Severity.WARN, sb.toString(), null);
        }
        return newDocs;
    }

    protected List<DocumentModel> recreateDocumentsWithNewParent(DocumentModel parent, List<DocumentModel> documents) throws ClientException {
        ArrayList<DocumentModel> copiedDocsList = new ArrayList<DocumentModel>();
        List newDocs = super.recreateDocumentsWithNewParent(parent, documents);
        for (DocumentModel newDoc : newDocs) {
            newDoc.refresh(1, null);
            if ("approved".equals(newDoc.getCurrentLifeCycleState())) {
                if (!newDoc.isCheckedOut()) {
                    newDoc.checkOut();
                }
                this.documentManager.followTransition(newDoc.getRef(), "backToProject");
            }
            this.documentManager.saveDocument(newDoc);
            if (newDoc.isFolder()) {
                this.removeProxy(newDoc);
            }
            copiedDocsList.add(newDoc);
        }
        return copiedDocsList;
    }

    protected void removeProxy(DocumentModel folder) throws ClientException {
        innerRemoveDocumentProxy runner = new innerRemoveDocumentProxy(this.documentManager, folder);
        runner.runUnrestricted();
    }

    private class innerRemoveDocumentProxy
    extends UnrestrictedSessionRunner {
        private DocumentModel folder;

        public innerRemoveDocumentProxy(CoreSession session, DocumentModel folder) {
            super(session);
            this.folder = folder;
        }

        public void run() throws ClientException {
            DocumentModelList proxies = this.session.query("SELECT * FROM Document WHERE ecm:path STARTSWITH '" + this.folder.getPathAsString() + "' AND ecm:isProxy = 1");
            for (DocumentModel proxy : proxies) {
                this.session.removeDocument(proxy.getRef());
            }
        }
    }
}

