/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.info.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.jboss.unit.TestId;
import org.jboss.unit.info.TestInfo;
import org.jboss.unit.info.TestSuiteInfo;
import org.jboss.unit.info.impl.SimpleParameterInfo;
import org.jboss.unit.info.impl.SimpleTestInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleTestSuiteInfo
extends SimpleTestInfo
implements TestSuiteInfo {
    private Map<String, SimpleTestInfo> tests = new HashMap<String, SimpleTestInfo>();

    public SimpleTestSuiteInfo(String name) {
        super(name);
    }

    public SimpleTestSuiteInfo(TestSuiteInfo that) {
        super(that);
        for (String testName : that.getNames()) {
            TestInfo test = that.getTest(testName);
            this.addTest(test);
        }
    }

    @Override
    public TestInfo getTest(String name) {
        return this.tests.get(name);
    }

    @Override
    public Set<String> getNames() {
        return Collections.unmodifiableSet(this.tests.keySet());
    }

    @Override
    public TestInfo findTest(TestId id) {
        if (id == null) {
            throw new IllegalArgumentException("No null id accepted");
        }
        if (id.getLength() == 0) {
            return this;
        }
        TestInfo child = this.tests.get(id.getName(0));
        if (child == null) {
            return null;
        }
        if (child instanceof TestSuiteInfo) {
            return ((TestSuiteInfo)child).findTest(id.range(1));
        }
        if (id.getLength() == 1) {
            return child;
        }
        return null;
    }

    public void addTest(TestInfo test) {
        if (test == null) {
            throw new IllegalArgumentException();
        }
        this.tests.put(test.getName(), SimpleTestSuiteInfo.create(test));
        this.updateParameters();
    }

    public void removeTest(String testName) {
        if (testName == null) {
            throw new IllegalArgumentException();
        }
        this.tests.remove(testName);
        this.updateParameters();
    }

    private void updateParameters() {
        HashMap<String, SimpleParameterInfo> parameters = new HashMap<String, SimpleParameterInfo>();
        for (SimpleTestInfo child : this.tests.values()) {
            parameters.putAll(child.parameters);
        }
        this.parameters = parameters;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.getName());
        builder.append('[');
        Iterator<SimpleTestInfo> i = this.tests.values().iterator();
        while (i.hasNext()) {
            TestInfo test = i.next();
            builder.append(test);
            if (!i.hasNext()) continue;
            builder.append(',');
        }
        builder.append(']');
        return builder.toString();
    }
}

