/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.runner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParametrizationSet
implements Cloneable {
    private Map<String, String[]> map;

    public ParametrizationSet(Map<String, String[]> map) {
        this.map = map;
    }

    public ParametrizationSet() {
        this.map = new HashMap<String, String[]>();
    }

    public void combine(ParametrizationSet other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException();
        }
        for (Map.Entry<String, String[]> entry : other.map.entrySet()) {
            String key = entry.getKey();
            this.map.put(key, (String[])entry.getValue().clone());
        }
    }

    public ParametrizationSet clone() {
        try {
            return (ParametrizationSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public List<Map<String, String>> enumerate(Set<String> expectedParameters) {
        expectedParameters = expectedParameters != null ? new HashSet(expectedParameters) : null;
        ArrayList<Map<String, String>> enumeration = new ArrayList<Map<String, String>>();
        enumeration.add(new HashMap());
        for (Map.Entry<String, String[]> entry : this.map.entrySet()) {
            String parameterName = entry.getKey();
            if (expectedParameters != null && !expectedParameters.remove(parameterName)) continue;
            ArrayList tmp = new ArrayList();
            for (String occurrence : entry.getValue()) {
                for (Map map : enumeration) {
                    HashMap<String, String> copy = new HashMap<String, String>(map);
                    copy.put(parameterName, occurrence);
                    tmp.add(copy);
                }
            }
            enumeration = tmp;
        }
        return enumeration;
    }
}

