/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.tooling;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.unit.report.impl.junit.JUnitReporter;
import org.jboss.unit.report.impl.junit.JUnitTestsuiteReport;
import org.jboss.unit.runner.TestRunner;
import org.jboss.unit.runner.TestRunnerEventListener;
import org.jboss.unit.runner.impl.NullFilter;
import org.jboss.unit.runner.impl.TestRunnerEventBroadcaster;
import org.jboss.unit.runner.model.ModelBuilder;
import org.jboss.unit.runner.model.TestSuiteDef;
import org.jboss.unit.tooling.Main;
import org.jboss.unit.tooling.filter.ExcludeTestFilter;
import org.jboss.unit.tooling.filter.IncludeTestFilter;
import org.jboss.unit.tooling.filter.MainTestFilter;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainBuilder {
    private Set<String> keywords = new HashSet<String>();
    private Set<String> names = new HashSet<String>();
    private Set<String> namePatterns = new HashSet<String>();
    private Set<String> excludeKeywords = new HashSet<String>();
    private Set<String> excludeNames = new HashSet<String>();
    private Set<String> excludeNamePatterns = new HashSet<String>();
    private Set<TestRunnerEventListener> listeners = new HashSet<TestRunnerEventListener>();
    private String suiteName;
    private String configFile;
    private boolean noConsole = false;
    private boolean failonerror = false;
    private String xmlReportDir;
    private String htmlReportDir;
    private Map<String, String> properties = new HashMap<String, String>();
    private Map<String, List<String>> parameters = new HashMap<String, List<String>>();

    private MainBuilder() {
    }

    public MainBuilder(String configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException("configFile cannot be null");
        }
        this.configFile = configFile;
    }

    public MainBuilder(String configFile, String name) {
        this(configFile);
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.suiteName = name;
    }

    public MainBuilder addKeyword(String keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException("keyword cannot be null");
        }
        this.keywords.add(keyword);
        return this;
    }

    public MainBuilder addExcludeKeyword(String keyword) {
        if (keyword == null) {
            throw new IllegalArgumentException("keyword cannot be null");
        }
        this.excludeKeywords.add(keyword);
        return this;
    }

    public MainBuilder addUnparsedKeywords(String keywordsString) {
        String[] keywordValues;
        if (keywordsString == null) {
            throw new IllegalArgumentException("keywordsString cannot be null");
        }
        for (String keyword : keywordValues = keywordsString.split(",")) {
            this.keywords.add(keyword.trim());
        }
        return this;
    }

    public MainBuilder addUnparsedExcludeKeywords(String keywordsString) {
        String[] keywordValues;
        if (keywordsString == null) {
            throw new IllegalArgumentException("keywordsString cannot be null");
        }
        for (String keyword : keywordValues = keywordsString.split(",")) {
            this.excludeKeywords.add(keyword.trim());
        }
        return this;
    }

    public MainBuilder addName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.names.add(name);
        return this;
    }

    public MainBuilder addExcludeName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null");
        }
        this.excludeNames.add(name);
        return this;
    }

    public MainBuilder addUnparsedNames(String namesString) {
        String[] namesValues;
        if (namesString == null) {
            throw new IllegalArgumentException("namesString cannot be null");
        }
        for (String name : namesValues = namesString.split(",")) {
            this.names.add(name.trim());
        }
        return this;
    }

    public MainBuilder addUnparsedExcludeNames(String namesString) {
        String[] namesValues;
        if (namesString == null) {
            throw new IllegalArgumentException("namesString cannot be null");
        }
        for (String name : namesValues = namesString.split(",")) {
            this.excludeNames.add(name.trim());
        }
        return this;
    }

    public MainBuilder addNamePattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern cannot be null");
        }
        this.namePatterns.add(pattern);
        return this;
    }

    public MainBuilder addExcludeNamePattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern cannot be null");
        }
        this.excludeNamePatterns.add(pattern);
        return this;
    }

    public MainBuilder addUnparsedNamePatterns(String patternString) {
        String[] patternValues;
        if (patternString == null) {
            throw new IllegalArgumentException("patternString cannot be null");
        }
        for (String pattern : patternValues = patternString.split(",")) {
            this.namePatterns.add(pattern.trim());
        }
        return this;
    }

    public MainBuilder addUnparsedExcludeNamePatterns(String patternString) {
        String[] patternValues;
        if (patternString == null) {
            throw new IllegalArgumentException("patternString cannot be null");
        }
        for (String pattern : patternValues = patternString.split(",")) {
            this.excludeNamePatterns.add(pattern.trim());
        }
        return this;
    }

    public MainBuilder addJUnitReporting(String directory) {
        if (directory == null) {
            throw new IllegalArgumentException("directory cannot be null");
        }
        this.listeners.add(new JUnitReporter(directory, this.suiteName));
        return this;
    }

    public MainBuilder addUnparsedProperty(String propertyString) {
        if (propertyString == null) {
            throw new IllegalArgumentException("No null property name accepted");
        }
        String[] patternValues = (propertyString = propertyString.replaceFirst("--property\\.", "")).split("=");
        if (patternValues.length != 2) {
            throw new IllegalArgumentException("Property not accepted, it should match a=b and it is " + propertyString);
        }
        this.properties.put(patternValues[0], patternValues[1]);
        return this;
    }

    public MainBuilder addProperty(String propertyName, String propertyValue) {
        if (propertyName == null) {
            throw new IllegalArgumentException("No null property name accepted");
        }
        this.properties.put(propertyName, propertyValue);
        return this;
    }

    public void addUnparsedProperties(String propertiesString) {
        if (propertiesString == null) {
            throw new IllegalArgumentException("Properties cannot be null");
        }
        Map<String, String> props = MainBuilder.parseProperties(propertiesString);
        for (String key : props.keySet()) {
            this.addProperty(key, props.get(key));
        }
    }

    public static Map<String, String> parseProperties(String propertiesString) {
        String[] propertyGroups;
        if (!propertiesString.matches("\\[.+=.+(,.+=.+)*\\]")) {
            throw new IllegalArgumentException("Parameters don't follow proper format: [a=b,c=d,e=f]");
        }
        HashMap<String, String> parsedProps = new HashMap<String, String>();
        propertiesString = propertiesString.replaceAll("\\[", "").replaceAll("\\]", "");
        for (String propertyGroup : propertyGroups = propertiesString.split(",")) {
            String[] property = propertyGroup.split("=");
            if (property.length != 2) {
                throw new IllegalArgumentException("Property not accepted, it should match a=b and it is " + property);
            }
            parsedProps.put(property[0], property[1]);
        }
        return parsedProps;
    }

    public void addUnparsedParameter(String paramString) {
        String[] parameter = (paramString = paramString.replaceFirst("--parameter\\.", "")).split("=", 2);
        if (parameter.length != 2) {
            throw new IllegalArgumentException("Parameter not accepted, it should match a=b and it is " + paramString);
        }
        LinkedList<String> parameterValues = new LinkedList<String>();
        if (parameter[1].matches("\\[.+(,.+)*\\]")) {
            String[] values;
            String valuesString = parameter[1];
            valuesString = valuesString.replaceAll("\\[", "").replaceAll("\\]", "");
            for (String value : values = valuesString.split(",")) {
                parameterValues.add(value);
            }
        } else {
            parameterValues.add(parameter[1]);
        }
        if (this.parameters.containsKey(parameter[0])) {
            this.parameters.get(parameter[0]).addAll(parameterValues);
        } else {
            this.parameters.put(parameter[0], parameterValues);
        }
    }

    public void addUnparsedParameters(String parametersString) {
        String[] parameterGroups;
        parametersString = parametersString.replaceAll("\\[", "").replaceAll("\\]", "");
        for (String parameterGroup : parameterGroups = parametersString.split(",")) {
            String[] parameter = parameterGroup.split("=");
            if (parameter.length != 2) {
                throw new IllegalArgumentException("Parameter not accepted, it should match a=b and it is " + parameter);
            }
            List<String> values = this.parameters.containsKey(parameter[0]) ? this.parameters.get(parameter[0]) : new LinkedList<String>();
            values.add(parameter[1]);
            this.parameters.put(parameter[0], values);
        }
    }

    public Map<String, String[]> getParameters() {
        HashMap<String, String[]> params = new HashMap<String, String[]>();
        for (String paramKey : this.parameters.keySet()) {
            List<String> values = this.parameters.get(paramKey);
            params.put(paramKey, values.toArray(new String[values.size()]));
        }
        return params;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }

    public void setNoConsole(boolean noConsole) {
        this.noConsole = noConsole;
    }

    public boolean isFailonerror() {
        return this.failonerror;
    }

    public void setFailonerror(boolean failonerror) {
        this.failonerror = failonerror;
    }

    public void setXMLReportDir(String xmlReportDir) {
        this.xmlReportDir = xmlReportDir;
    }

    public void setHTMLReportDir(String htmlReportDir) {
        this.htmlReportDir = htmlReportDir;
    }

    public Main build() throws Exception {
        InputStream in;
        try {
            in = new FileInputStream(this.configFile);
        }
        catch (FileNotFoundException e) {
            in = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.configFile);
        }
        if (in == null) {
            throw new IllegalArgumentException("Could not find specified file in classpath: " + this.configFile);
        }
        InputSource source = new InputSource(in);
        ModelBuilder builder = new ModelBuilder(source);
        TestSuiteDef suite = builder.build();
        TestRunner runner = suite.createRunner();
        TestRunnerEventBroadcaster broadcaster = new TestRunnerEventBroadcaster();
        for (TestRunnerEventListener listener : this.listeners) {
            broadcaster.addListener(listener);
        }
        File htmlReportFile = null;
        if (this.htmlReportDir != null) {
            htmlReportFile = MainBuilder.checkCreateOutputDirectory(this.htmlReportDir);
        }
        File xmlReportFile = null;
        if (this.xmlReportDir != null) {
            xmlReportFile = MainBuilder.checkCreateOutputDirectory(this.xmlReportDir);
        }
        JUnitTestsuiteReport fileReporter = new JUnitTestsuiteReport(xmlReportFile, htmlReportFile);
        broadcaster.addListener(fileReporter);
        MainTestFilter filter = new MainTestFilter();
        if (this.keywords.size() == 0 && this.names.size() == 0 && this.namePatterns.size() == 0) {
            filter.addIncludeFilter(new NullFilter());
        } else {
            filter.addIncludeFilter(new IncludeTestFilter(this.keywords, this.names, this.namePatterns));
        }
        if (this.excludeKeywords.size() != 0 || this.excludeNames.size() != 0 || this.excludeNamePatterns.size() != 0) {
            filter.addExcludeFilter(new ExcludeTestFilter(this.excludeKeywords, this.excludeNames, this.excludeNamePatterns));
        }
        return new Main(runner, filter, broadcaster, suite, this.properties, this.getParameters(), this.isFailonerror());
    }

    public static File checkCreateOutputDirectory(String dir) throws Exception {
        try {
            File output = new File(dir);
            if (!output.exists()) {
                output.mkdirs();
            } else if (!output.isDirectory()) {
                throw new IllegalStateException("Provided path points to a file instead of directory");
            }
            return output;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to use provided output directory: '" + dir + "'", e);
        }
    }
}

