/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.unit.tooling;

import java.io.PrintStream;
import org.jboss.unit.tooling.ByteArrayOutputStreamExt;
import org.jboss.unit.tooling.ForkedOutputStream;
import org.jboss.unit.tooling.SystemOutputView;

public class SystemOutputManager {
    private static SystemOutputManager instance;
    private PrintStream originalOut;
    private PrintStream originalErr;
    private ByteArrayOutputStreamExt baosOut;
    private ByteArrayOutputStreamExt baosErr;

    public static SystemOutputManager getInstance() {
        return instance;
    }

    public SystemOutputView createView(boolean fullHistory) {
        return new SystemOutputView(this.baosOut, this.baosErr, fullHistory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Class<SystemOutputManager> clazz = SystemOutputManager.class;
        synchronized (SystemOutputManager.class) {
            if (instance != null) {
                throw new IllegalStateException();
            }
            this.baosOut = new ByteArrayOutputStreamExt();
            this.baosErr = new ByteArrayOutputStreamExt();
            this.originalOut = System.out;
            this.originalErr = System.err;
            ForkedOutputStream fOut = new ForkedOutputStream(this.originalOut, this.baosOut);
            ForkedOutputStream fErr = new ForkedOutputStream(this.originalErr, this.baosErr);
            System.setOut(new PrintStream(fOut, true));
            System.setErr(new PrintStream(fErr, true));
            instance = this;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Class<SystemOutputManager> clazz = SystemOutputManager.class;
        synchronized (SystemOutputManager.class) {
            if (instance != null) {
                System.out.flush();
                System.err.flush();
                instance = null;
                System.setOut(this.originalOut);
                System.setErr(this.originalErr);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

