/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.batch;

import com.google.inject.Inject;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.UUID;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.test.EmbeddedAutomationServerFeature;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.runtime.test.runner.Features;
import org.nuxeo.runtime.test.runner.FeaturesRunner;
import org.nuxeo.runtime.test.runner.Jetty;
import org.nuxeo.runtime.transaction.TransactionHelper;

@RunWith(value=FeaturesRunner.class)
@Features(value={EmbeddedAutomationServerFeature.class})
@Jetty(port=18080)
public class TestBatchResource {
    @Inject
    protected CoreSession session;
    @Inject
    protected Session clientSession;

    @Test
    public void testBatchUpload() throws Exception {
        DocumentModel file = this.session.createDocumentModel("/", "testFile", "File");
        file = this.session.createDocument(file);
        TransactionHelper.commitOrRollbackTransaction();
        TransactionHelper.startTransaction();
        String uploadURL = "http://localhost:18080/automation/batch/upload";
        String executeURL = "http://localhost:18080/automation/batch/execute";
        String batchId = UUID.randomUUID().toString();
        String fileIndex = "0";
        String fileName = "New file.txt";
        String mimeType = "text/plain";
        String content = "This is the content of a new file.";
        String docPath = file.getPathAsString();
        if (this.batchUpload(uploadURL, batchId, fileIndex, fileName, mimeType, content)) {
            this.batchExecuteAttachBlob(executeURL, batchId, fileIndex, docPath);
        } else {
            Assert.fail((String)"File upload failed");
        }
        Blob blob = (Blob)this.clientSession.newRequest("Blob.Get").setInput((Object)file.getPathAsString()).execute();
        Assert.assertNotNull((Object)blob);
        String blobString = new String(IOUtils.toByteArray((InputStream)blob.getStream()));
        Assert.assertEquals((Object)"This is the content of a new file.", (Object)blobString);
    }

    /*
     * Loose catch block
     */
    protected boolean batchUpload(String urlStr, String batchId, String fileIndex, String fileName, String mimeType, String content) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            byte[] bytes = content.getBytes();
            String fileSize = Integer.toString(bytes.length);
            conn.setRequestProperty("Authorization", this.getAuthHeader("Administrator", "Administrator"));
            conn.setRequestProperty("X-Batch-Id", batchId);
            conn.setRequestProperty("X-File-Idx", fileIndex);
            conn.setRequestProperty("X-File-Name", fileName);
            conn.setRequestProperty("X-File-Size", fileSize);
            conn.setRequestProperty("X-File-Type", mimeType);
            conn.setRequestProperty("Content-Type", "application/octet-stream");
            conn.setRequestProperty("Content-Length", fileSize);
            conn.setDoOutput(true);
            try (OutputStream os = conn.getOutputStream();){
                IOUtils.write((String)content, (OutputStream)os);
            }
            var12_12 = null;
            try (InputStream is = conn.getInputStream();){
                IOUtils.toByteArray((InputStream)is);
                boolean bl = conn.getResponseCode() == 200;
                return bl;
            }
            catch (Throwable throwable) {
                var12_12 = throwable;
                throw throwable;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            conn.disconnect();
        }
    }

    /*
     * Loose catch block
     */
    protected boolean batchExecuteAttachBlob(String urlStr, String batchId, String fileIndex, String docPath) throws IOException {
        URL url = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        try {
            conn.setRequestProperty("Authorization", this.getAuthHeader("Administrator", "Administrator"));
            conn.setRequestProperty("Content-Type", "application/json+nxrequest");
            conn.setRequestProperty("Accept", "application/json+nxentity, */*");
            conn.setRequestProperty("X-NXDocumentProperties", "*");
            conn.setDoOutput(true);
            String JSONData = String.format("{\"params\": {\"operationId\": \"%s\", \"batchId\": \"%s\", \"fileIdx\": \"%s\", \"document\": \"%s\"}}", "Blob.Attach", batchId, fileIndex, docPath);
            try (OutputStream os = conn.getOutputStream();){
                IOUtils.write((String)JSONData, (OutputStream)os);
            }
            var9_9 = null;
            try (InputStream is = conn.getInputStream();){
                IOUtils.toByteArray((InputStream)is);
                boolean bl = conn.getResponseCode() == 200;
                return bl;
            }
            catch (Throwable throwable) {
                var9_9 = throwable;
                throw throwable;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            conn.disconnect();
        }
    }

    protected String getAuthHeader(String userName, String password) {
        return "Basic " + new String(Base64.encodeBase64((byte[])(userName + ":" + password).getBytes()));
    }
}

