/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.context;

import java.util.List;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.nuxeo.ecm.automation.server.jaxrs.ResponseHelper;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

public class TestResponseHelper {
    @Test
    public void shouldGetBlobResponseWithHeaders() {
        StringBlob blob = new StringBlob("my doc content", "text/html", "ISO-8859-1");
        blob.setFilename("My doc name");
        Response response = ResponseHelper.blob((Blob)blob);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertTrue((boolean)response.getMetadata().containsKey((Object)"Content-Disposition"));
        Assert.assertEquals((Object)"attachment; filename=My doc name", ((List)response.getMetadata().get((Object)"Content-Disposition")).get(0));
        Assert.assertTrue((boolean)response.getMetadata().containsKey((Object)"Content-Type"));
        Assert.assertEquals((Object)"text/html; charset=ISO-8859-1", (Object)((List)response.getMetadata().get((Object)"Content-Type")).get(0).toString());
        StringBlob blob2 = new StringBlob("my doc 2 content");
        Response response2 = ResponseHelper.blob((Blob)blob2);
        Assert.assertEquals((Object)"text/plain; charset=UTF-8", (Object)((List)response2.getMetadata().get((Object)"Content-Type")).get(0).toString());
    }
}

