/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.groups.audit.service.acl.data;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.groups.audit.service.acl.Pair;
import org.nuxeo.ecm.platform.groups.audit.service.acl.data.AclSummaryExtractor;
import org.nuxeo.ecm.platform.groups.audit.service.acl.data.DataFetch;
import org.nuxeo.ecm.platform.groups.audit.service.acl.data.DocumentSummary;
import org.nuxeo.ecm.platform.groups.audit.service.acl.data.IDataProcessor;
import org.nuxeo.ecm.platform.groups.audit.service.acl.data.TicToc;
import org.nuxeo.ecm.platform.groups.audit.service.acl.filter.IContentFilter;

public class DataProcessor
implements IDataProcessor {
    protected static Log log = LogFactory.getLog(DataProcessor.class);
    protected int documentMinDepth;
    protected int documentTreeDepth;
    protected SortedSet<String> userAndGroups;
    protected SortedSet<String> permissions;
    protected ProcessorStatus status;
    protected String information;
    protected Collection<DocumentSummary> allDocuments;
    protected IContentFilter filter;
    protected AclSummaryExtractor acl;
    protected int n;
    protected TicToc t = new TicToc();

    public DataProcessor(IContentFilter filter) {
        this.filter = filter;
        this.acl = new AclSummaryExtractor(filter);
    }

    @Override
    public void analyze(CoreSession session) throws ClientException {
        this.analyze(session, session.getRootDocument(), 0);
    }

    @Override
    public void analyze(CoreSession session, DocumentModel doc, int timeout) throws ClientException {
        this.init();
        this.doAnalyze(session, doc, timeout);
        this.log();
    }

    public void init() {
        this.userAndGroups = new TreeSet<String>();
        this.permissions = new TreeSet<String>();
        this.documentMinDepth = Integer.MAX_VALUE;
        this.documentTreeDepth = 0;
    }

    protected void doAnalyze(CoreSession session, DocumentModel root, int timeout) throws ClientException {
        DocumentModelList list;
        DataFetch fetch = new DataFetch();
        try {
            list = fetch.getAllChildren(session, root);
        }
        catch (IOException e) {
            throw new ClientException((Throwable)e);
        }
        this.initSummarySet();
        this.processDocument(root);
        this.n = list.size();
        this.t.tic();
        for (DocumentModel d : list) {
            this.processDocument(d);
        }
        this.status = ProcessorStatus.SUCCESS;
    }

    protected void initSummarySet() {
        this.allDocuments = new ArrayList<DocumentSummary>(1000);
    }

    protected void processDocument(DocumentModel doc) throws ClientException {
        DocumentSummary da = this.computeSummary(doc);
        this.updateTreeSize(da);
        this.computeGlobalAclSummary(doc);
        this.allDocuments.add(da);
    }

    protected DocumentSummary computeSummary(DocumentModel doc) throws ClientException {
        String title = doc.getTitle();
        String path = doc.getPathAsString();
        if (path == null) {
            path = "";
        }
        int depth = this.computeDepth(doc);
        boolean lock = this.acl.hasLockInheritanceACE(doc);
        Multimap<String, Pair<String, Boolean>> aclLo = this.acl.getAclLocalByUser(doc);
        Multimap<String, Pair<String, Boolean>> aclIn = this.acl.getAclInheritedByUser(doc);
        DocumentSummary da = new DocumentSummary(title, depth, lock, aclLo, aclIn, path);
        return da;
    }

    protected int computeDepth(DocumentModel m) {
        Path path = m.getPath();
        return path.segmentCount();
    }

    protected int updateTreeSize(DocumentSummary da) {
        int depth = da.getDepth();
        if (depth > this.documentTreeDepth) {
            this.documentTreeDepth = depth;
        }
        if (depth < this.documentMinDepth) {
            this.documentMinDepth = depth;
        }
        return depth;
    }

    protected void computeGlobalAclSummary(DocumentModel doc) throws ClientException {
        Pair<HashSet<String>, HashSet<String>> s = this.acl.getAclSummary(doc);
        this.userAndGroups.addAll((Collection)s.a);
        this.permissions.addAll((Collection)s.b);
    }

    @Override
    public Collection<DocumentSummary> getAllDocuments() {
        return this.allDocuments;
    }

    @Override
    public Set<String> getUserAndGroups() {
        return this.userAndGroups;
    }

    @Override
    public Set<String> getPermissions() {
        return this.permissions;
    }

    @Override
    public int getDocumentTreeMaxDepth() {
        return this.documentTreeDepth;
    }

    @Override
    public int getDocumentTreeMinDepth() {
        return this.documentMinDepth;
    }

    @Override
    public int getNumberOfDocuments() {
        return this.allDocuments.size();
    }

    @Override
    public ProcessorStatus getStatus() {
        return this.status;
    }

    @Override
    public String getInformation() {
        return this.information;
    }

    public void log() {
        log.debug((Object)("doc tree depth    : " + this.getDocumentTreeMaxDepth()));
        log.debug((Object)("#docs (or folders): " + this.getNumberOfDocuments() + " (analyzed by processor, may differ from actual number of doc in repo if exceeding timeout or max number of doc)"));
        log.debug((Object)("#users (or groups): " + this.getUserAndGroups().size() + " (mentionned in ACLs, may differ from actual user directory)"));
        log.debug((Object)("#permissions types: " + this.getPermissions().size() + " (mentionned in ACLs)"));
    }

    public static enum ProcessorStatus {
        SUCCESS,
        ERROR_TOO_MANY_DOCUMENTS,
        ERROR_TOO_LONG_PROCESS,
        ERROR;

    }
}

