/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.customizer.attributes;

import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.model.portal.command.render.RenderPageCommand;
import org.jboss.portal.core.theme.PageRendition;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.theming.IAttributesBundle;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;
import org.osivia.portal.core.cms.ICMSServiceLocator;

public class CustomizedAttributesBundle
implements IAttributesBundle {
    private static final String APPLICATIONS = "osivia.sso.applications";
    private static final String USER_WORKSPACE_URL = "osivia.userWorkspace.url";
    private static final IAttributesBundle INSTANCE = new CustomizedAttributesBundle();
    private final Log log = LogFactory.getLog(this.getClass());
    private final Set<String> names = new HashSet();
    private final List<String> applications;
    private final IPortalUrlFactory portalUrlFactory;
    private final ICMSServiceLocator cmsServiceLocator;

    private CustomizedAttributesBundle() {
        this.names.add(APPLICATIONS);
        this.names.add(USER_WORKSPACE_URL);
        this.applications = new ArrayList();
        this.applications.add(NuxeoConnectionProperties.getPublicBaseUri().toString().concat("/logout"));
        this.applications.add(System.getProperty("cas.logout"));
        this.portalUrlFactory = (IPortalUrlFactory)Locator.findMBean(IPortalUrlFactory.class, (String)"osivia:service=UrlFactory");
        this.cmsServiceLocator = (ICMSServiceLocator)Locator.findMBean(ICMSServiceLocator.class, (String)"osivia:service=CmsServiceLocator");
    }

    public static IAttributesBundle getInstance() {
        return INSTANCE;
    }

    public void fill(RenderPageCommand renderPageCommand, PageRendition pageRendition, Map<String, Object> attributes) throws ControllerException {
        ControllerContext controllerContext = renderPageCommand.getControllerContext();
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)controllerContext);
        ICMSService cmsService = this.cmsServiceLocator.getCMSService();
        CMSServiceCtx cmsContext = new CMSServiceCtx();
        cmsContext.setPortalControllerContext(portalControllerContext);
        attributes.put(APPLICATIONS, this.applications);
        CMSItem userWorkspace = null;
        try {
            List userWorkspaces = cmsService.getWorkspaces(cmsContext, true, false);
            if (userWorkspaces != null && userWorkspaces.size() == 1) {
                userWorkspace = (CMSItem)userWorkspaces.get(0);
            }
        }
        catch (CMSException e) {
            this.log.error((Object)"Unable to get user workspaces.", e.fillInStackTrace());
        }
        if (userWorkspace != null && StringUtils.isNotEmpty((String)userWorkspace.getPath())) {
            String userWorkspaceUrl = this.portalUrlFactory.getCMSUrl(portalControllerContext, null, userWorkspace.getPath(), null, null, null, null, null, null, null);
            attributes.put(USER_WORKSPACE_URL, userWorkspaceUrl);
        }
    }

    public Set<String> getAttributeNames() {
        return this.names;
    }
}

