/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.customizer.plugin.list;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.portlet.PortletModule;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.demo.customizer.plugin.DemoUtils;

public class AccessoriesListTemplateModule
extends PortletModule {
    private static final String PROCEDURE_COMMANDE_WEBID = "procedure_commande_produit";

    public AccessoriesListTemplateModule(PortletContext portletContext) {
        super(portletContext);
    }

    protected void doView(RenderRequest request, RenderResponse response, PortletContext portletContext) throws PortletException, IOException {
        List documents = (List)request.getAttribute("documents");
        if (CollectionUtils.isNotEmpty((Collection)documents)) {
            NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, portletContext);
            for (DocumentDTO documentDTO : documents) {
                Map properties = documentDTO.getProperties();
                PropertyMap docProperties = documentDTO.getDocument().getProperties();
                PropertyMap dataMap = docProperties.getMap("rcd:data");
                if (dataMap == null) continue;
                properties.put("title", dataMap.getString("_title"));
                PropertyMap visuelMap = dataMap.getMap("visuel");
                if (visuelMap != null) {
                    properties.put("visuelUrl", DemoUtils.getFileUrl((NuxeoController)nuxeoController, (PropertyMap)docProperties, (String)visuelMap.getString("digest"), (String)documentDTO.getPath()));
                    properties.put("visuelFilename", visuelMap.get("fileName"));
                }
                properties.put("description", dataMap.get("description"));
                properties.put("prixht", dataMap.get("prixht"));
                properties.put("orderUrl", this.getOrderUrl(PROCEDURE_COMMANDE_WEBID, nuxeoController, docProperties.getString("ttc:webid")));
            }
        }
    }

    private String getOrderUrl(String procedureWebid, NuxeoController nuxeoController, String webid) {
        JSONObject variables = new JSONObject();
        variables.put((Object)"accessoire", (Object)webid);
        return DemoUtils.getLaunchProcedureUrl((NuxeoController)nuxeoController, (JSONObject)variables, (String)procedureWebid);
    }
}

