/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.initializer.portlet;

import java.io.IOException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;
import org.osivia.demo.initializer.service.InitializerService;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(value={"VIEW"})
public class InitializerController {
    private static final String DEFAULT_VIEW = "view";
    private static final String NOAJAX_VIEW = "view-noajax";
    @Autowired
    private InitializerService service;
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private IPortalUrlFactory urlFactory;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        if (window.getProperty("noajax") != null) {
            PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
            this.service.initialize(portalControllerContext);
            return NOAJAX_VIEW;
        }
        return DEFAULT_VIEW;
    }

    @ActionMapping(params={"action=checkInit"})
    public void checkInit(ActionRequest request, ActionResponse response) throws PortalException, IOException, PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        this.service.initialize(portalControllerContext);
        HttpServletRequest servletRequest = (HttpServletRequest)request.getAttribute("osivia.httpRequest");
        String redirectUrl = (String)servletRequest.getSession().getAttribute("osivia.platform.init.pathToRedirect");
        if (redirectUrl != null) {
            String closeURL = this.urlFactory.getDestroyCurrentPageUrl(portalControllerContext, redirectUrl);
            response.sendRedirect(closeURL);
        }
    }
}

