/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.initializer.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import fr.toutatice.portail.cms.nuxeo.api.workspace.WorkspaceType;
import java.util.ArrayList;
import java.util.List;
import javax.naming.Name;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.demo.initializer.service.InitializerService;
import org.osivia.demo.initializer.service.commands.CreateExtranetCommand;
import org.osivia.demo.initializer.service.commands.CreateProcedureContainerCommand;
import org.osivia.demo.initializer.service.commands.CreateProcedureModelsCommand;
import org.osivia.demo.initializer.service.commands.LoadRecordsCommand;
import org.osivia.directory.v2.model.PortalGroup;
import org.osivia.directory.v2.service.PersonUpdateService;
import org.osivia.directory.v2.service.PortalGroupService;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.services.workspace.portlet.model.WorkspaceCreationForm;
import org.osivia.services.workspace.portlet.service.WorkspaceCreationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Service;

@Service
public class InitalizerServiceImpl
implements InitializerService {
    @Autowired
    private WorkspaceCreationService workspaceCreationService;
    @Autowired
    private PersonUpdateService personService;
    @Autowired
    private PortalGroupService service;

    @Bean
    public PortalGroupService getPortalGroupService() {
        return (PortalGroupService)DirServiceFactory.getService(PortalGroupService.class);
    }

    public void initialize(PortalControllerContext portalControllerContext) throws PortletException {
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        nuxeoController.setAsynchronousCommand(false);
        String cn = "sav";
        PortalGroup portalGroup = this.service.create(cn);
        portalGroup.setDisplayName("Service apr\u00e8s-vente");
        portalGroup.setDescription(StringUtils.trimToNull((String)"Tous les techniciens qui interviennent en support"));
        Person person = this.personService.getEmptyPerson();
        person.setUid("technicien");
        person.setCn("technicien");
        person.setSn("technicien");
        person.setGivenName("technicien");
        person.setDisplayName("technicien osivia");
        person.setTitle("M.");
        this.personService.create(person);
        this.personService.updatePassword(person, "osivia");
        Person searchPerson = this.personService.getEmptyPerson();
        searchPerson.setUid("*");
        List persons = this.personService.findByCriteria(searchPerson);
        for (Person aPerson : persons) {
            aPerson.setMail("demo@osivia.com");
            this.personService.update(aPerson);
        }
        ArrayList<Name> listName = new ArrayList<Name>();
        listName.add(person.getDn());
        portalGroup.setMembers(listName);
        this.service.update(portalGroup);
        Document modelsContainer = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)new CreateProcedureContainerCommand());
        nuxeoController.executeNuxeoCommand((INuxeoCommand)new CreateProcedureModelsCommand(modelsContainer));
        nuxeoController.executeNuxeoCommand((INuxeoCommand)new CreateExtranetCommand());
        String workspaceId = "Espace de test";
        WorkspaceCreationForm form = new WorkspaceCreationForm();
        form.setTitle(workspaceId);
        form.setDescription(workspaceId);
        form.setType(WorkspaceType.PRIVATE);
        Person owner = this.personService.getPerson("admin");
        form.setOwner(owner.getUid());
        this.workspaceCreationService.create(portalControllerContext, form);
        nuxeoController.executeNuxeoCommand((INuxeoCommand)new LoadRecordsCommand());
    }

    private NuxeoController getNuxeoController(PortalControllerContext portalControllerContext) {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        PortletContext portletContext = portalControllerContext.getPortletCtx();
        return new NuxeoController(request, response, portletContext);
    }
}

