/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.initializer.service.commands;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.File;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.OperationInput;
import org.nuxeo.ecm.automation.client.model.PathRef;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

public class CreateExtranetCommand
implements INuxeoCommand {
    private Log logger = LogFactory.getLog(CreateExtranetCommand.class);

    public Object execute(Session nuxeoSession) throws Exception {
        Document domain;
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        Document repository = documentService.getDocument((DocRef)new PathRef("/"));
        Documents extranetDomain = documentService.query("SELECT * FROM Domain WHERE ecm:path STARTSWITH '/extranet'");
        if (extranetDomain.size() < 1) {
            PropertyMap properties = new PropertyMap();
            properties.set("dc:title", "Extranet");
            domain = documentService.createDocument((DocRef)repository, "Domain", "extranet", properties);
        } else {
            domain = extranetDomain.get(0);
        }
        URL webconfigurationUrl = this.getClass().getResource("/docs/extranet/export-webconfiguration.zip");
        File webconfiguration = new File(webconfigurationUrl.getFile());
        FileBlob blob = new FileBlob(webconfiguration);
        OperationRequest operationRequest = nuxeoSession.newRequest("FileManager.Import").setInput((OperationInput)blob);
        operationRequest.setContextProperty("currentDocument", (Object)domain);
        operationRequest.set("overwite", (Object)"true");
        operationRequest.execute();
        URL extranetUrl = this.getClass().getResource("/docs/extranet/export-pages-extranet.zip");
        File extranet = new File(extranetUrl.getFile());
        blob = new FileBlob(extranet);
        operationRequest = nuxeoSession.newRequest("FileManager.Import").setInput((OperationInput)blob);
        operationRequest.setContextProperty("currentDocument", (Object)domain);
        operationRequest.set("overwite", (Object)"true");
        operationRequest.execute();
        Document accueil = (Document)nuxeoSession.newRequest("Document.FetchLiveDocument").setHeader("X-NXDocumentProperties", "*").set("value", (Object)"/extranet/home/message-d-accueil").set("permission", (Object)"Read").execute();
        PropertyMap properties = new PropertyMap();
        String accueilProp = accueil.getString("note:note");
        accueilProp = StringUtils.replace((String)accueilProp, (String)"public-url", (String)System.getProperty("demo.extranet.url"));
        accueilProp = StringUtils.replace((String)accueilProp, (String)"intra-url", (String)System.getProperty("demo.intranet.url"));
        properties.set("note:note", accueilProp);
        documentService.update((DocRef)accueil, properties);
        Documents extranetPages = documentService.query("SELECT * FROM Document WHERE ecm:path STARTSWITH '/extranet/home'");
        for (Document page : extranetPages) {
            this.logger.info((Object)("Publish page : " + page.getPath()));
            operationRequest = nuxeoSession.newRequest("Document.SetOnLineOperation").setInput((OperationInput)page);
            operationRequest.execute();
        }
        return null;
    }

    public String getId() {
        return this.getClass().getSimpleName();
    }
}

