/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.initializer.service.commands;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.File;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.OperationInput;

public class CreateProcedureModelsCommand
implements INuxeoCommand {
    private Log logger = LogFactory.getLog(CreateProcedureModelsCommand.class);
    private Document modelsContainer;

    public CreateProcedureModelsCommand(Document modelsContainer) {
        this.modelsContainer = modelsContainer;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        URL proceduresUrl = this.getClass().getResource("/docs/models/");
        File dir = new File(proceduresUrl.getFile());
        File[] procedures = dir.listFiles();
        for (int i = 0; i < procedures.length; ++i) {
            this.logger.info((Object)("Add procedure : " + procedures[i].getName()));
            try {
                FileBlob blob = new FileBlob(procedures[i]);
                OperationRequest operationRequest = nuxeoSession.newRequest("FileManager.Import").setInput((OperationInput)blob);
                operationRequest.setContextProperty("currentDocument", (Object)this.modelsContainer.getId());
                operationRequest.set("overwite", (Object)"true");
                operationRequest.execute();
                continue;
            }
            catch (Exception e) {
                this.logger.error((Object)("Error when importing procedure : " + procedures[i].getName()));
            }
        }
        return null;
    }

    public String getId() {
        return this.getClass().getSimpleName();
    }
}

