/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.comments;

import fr.toutatice.portail.cms.nuxeo.api.domain.Comment;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.dom4j.Element;
import org.dom4j.QName;
import org.dom4j.dom.DOMElement;

public class CommentsFormatter {
    private final List<Comment> comments;

    public CommentsFormatter(List<Comment> comments) {
        this.comments = comments;
    }

    public String generateHTMLContent() {
        Element root = this.generateRootNode();
        for (Comment comment : this.comments) {
            Element commentNode = this.generateCommentNode(comment);
            root.add(commentNode);
        }
        return root.asXML();
    }

    protected Element generateRootNode() {
        DOMElement node = new DOMElement(QName.get((String)"div"));
        node.addAttribute(QName.get((String)"class"), "comments");
        return node;
    }

    protected Element generateCommentNode(Comment comment) {
        DOMElement node = new DOMElement(QName.get((String)"div"));
        node.addAttribute(QName.get((String)"class"), "comment");
        Element author = this.generateCommentAttribute("author", comment.getAuthor());
        node.add(author);
        Element creationDate = this.generateCommentAttribute("creation-date", comment.getCreationDate());
        node.add(creationDate);
        Element content = this.generateCommentAttribute("content", comment.getCreationDate());
        node.add(content);
        Element actions = this.generateCommentActions(comment);
        node.add(actions);
        if (CollectionUtils.isNotEmpty((Collection)comment.getChildren())) {
            Element children = this.generateChildrenNode(comment);
            node.add(children);
        }
        return node;
    }

    protected Element generateCommentAttribute(String name, String value) {
        DOMElement node = new DOMElement(QName.get((String)"div"));
        node.addAttribute(QName.get((String)"class"), name);
        node.setText(value);
        return node;
    }

    protected Element generateCommentActions(Comment comment) {
        DOMElement node = new DOMElement(QName.get((String)"div"));
        node.addAttribute(QName.get((String)"class"), "actions");
        return node;
    }

    protected Element generateChildrenNode(Comment comment) {
        DOMElement node = new DOMElement(QName.get((String)"div"));
        node.addAttribute(QName.get((String)"class"), "children");
        for (Comment child : comment.getChildren()) {
            Element childNode = this.generateCommentNode(child);
            node.add(childNode);
        }
        return node;
    }
}

