/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.comments;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.InputStream;
import net.sf.json.JSONArray;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;

public class GetCommentsCommand
implements INuxeoCommand {
    private final Document document;

    public GetCommentsCommand(Document document) {
        this.document = document;
    }

    public JSONArray execute(Session nuxeoSession) throws Exception {
        OperationRequest request = nuxeoSession.newRequest("Fetch.DocumentComments");
        request.setHeader("X-NXDocumentProperties", "*");
        request.set("commentableDoc", (Object)this.document.getId());
        Blob commentsBlob = (Blob)request.execute();
        if (commentsBlob != null) {
            String fileContent = IOUtils.toString((InputStream)commentsBlob.getStream(), (String)"UTF-8");
            JSONArray jsonComments = JSONArray.fromObject((Object)fileContent);
            if (commentsBlob instanceof FileBlob) {
                ((FileBlob)commentsBlob).getFile().delete();
            }
            return jsonComments;
        }
        return new JSONArray();
    }

    public String getId() {
        return "Fetch.DocumentComments: " + this.document.getId();
    }
}

