/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfiguratinQueryCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.PortletContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSItemType;
import org.osivia.portal.core.cms.CMSServiceCtx;

/*
 * Exception performing whole class analysis ignored.
 */
public class CMSItemAdapter {
    private static final String NX_DC_TITLE = "dc:title";
    private static final String NX_DC_DESCRIPTION = "dc:description";
    private static final String NX_DC_CREATOR = "dc:creator";
    protected CMSService CMSService;
    protected DefaultCMSCustomizer customizer;
    protected PortletContext portletCtx;

    public CMSItemAdapter(PortletContext portletCtx, DefaultCMSCustomizer customizer, CMSService cmsService) {
        this.CMSService = cmsService;
        this.portletCtx = portletCtx;
        this.customizer = customizer;
    }

    public static String computeNavPath(String path) {
        String result = path;
        if (path.endsWith(".proxy")) {
            result = result.substring(0, result.length() - 6);
        }
        return result;
    }

    public void adaptItem(CMSServiceCtx ctx, CMSItem item) throws Exception {
        Document doc = (Document)item.getNativeItem();
        Map properties = item.getProperties();
        this.adaptDoc(ctx, doc, properties);
        this.adaptSEOProperties(ctx, doc, item.getMetaProperties());
    }

    public Map<String, String> adaptDocument(CMSServiceCtx ctx, Document doc) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.adaptDoc(ctx, doc, properties);
        return properties;
    }

    public boolean supportsOnlyPortalContextualization(CMSServiceCtx ctx, Document doc) {
        CMSItemType cmsItemType = (CMSItemType)this.customizer.getCMSItemTypes().get(doc.getType());
        return cmsItemType != null && cmsItemType.isForcePortalContextualization();
    }

    public void adaptNavigationProperties(CMSServiceCtx ctx, Document doc, Map<String, String> properties) throws Exception {
        WebConfiguratinQueryCommand command;
        Documents configs;
        String domainPath = WebConfigurationHelper.getDomainPath((CMSServiceCtx)ctx);
        if (domainPath != null && (configs = WebConfigurationHelper.executeWebConfigCmd((CMSServiceCtx)ctx, (CMSService)this.CMSService, (WebConfiguratinQueryCommand)(command = new WebConfiguratinQueryCommand(domainPath, WebConfiguratinQueryCommand.WebConfigurationType.CMSNavigationAdapter)))).size() > 0) {
            for (Document config : configs) {
                String documentType = config.getProperties().getString("wconf:code");
                String urlAdapted = config.getProperties().getString("wconf:code2");
                if (!doc.getType().equals(documentType)) continue;
                String path = CMSItemAdapter.computeNavPath((String)urlAdapted);
                properties.put("navigationPath", path);
                break;
            }
        }
    }

    private void adaptSEOProperties(CMSServiceCtx ctx, Document doc, Map<String, String> properties) {
        PropertyMap nxProperties = doc.getProperties();
        if (nxProperties.getString("dc:title") != null) {
            properties.put("osivia.header.title", nxProperties.getString("dc:title"));
        }
        if (nxProperties.getString("dc:description") != null) {
            properties.put("osivia.header.meta".concat(".description"), nxProperties.getString("dc:description"));
        }
        if (nxProperties.getString("dc:creator") != null) {
            properties.put("osivia.header.meta".concat(".author"), nxProperties.getString("dc:creator"));
        }
    }

    public void adaptDoc(CMSServiceCtx ctx, Document doc, Map<String, String> properties) throws Exception {
        if (this.supportsOnlyPortalContextualization(ctx, doc)) {
            properties.put("supportsOnlyPortalContextualization", "1");
        }
        this.adaptNavigationProperties(ctx, doc, properties);
    }
}

