/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.ContextualizationHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.files.SubType;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.WindowState;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.Window;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.contribution.IContributionService;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSItemType;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;

public class MenuBarFormater {
    CMSService cmsService;
    IPortalUrlFactory urlFactory;
    DefaultCMSCustomizer customizer;
    PortletContext portletCtx;
    IContributionService contributionService;
    public static final String MENU_BAR = "osivia.menuBar";

    public IPortalUrlFactory getPortalUrlFactory() throws Exception {
        if (this.urlFactory == null) {
            this.urlFactory = (IPortalUrlFactory)this.portletCtx.getAttribute("UrlService");
        }
        return this.urlFactory;
    }

    public IContributionService getContributionService() throws Exception {
        if (this.contributionService == null) {
            this.contributionService = (IContributionService)Locator.findMBean(IContributionService.class, (String)"osivia:service=ContributionService");
        }
        return this.contributionService;
    }

    public MenuBarFormater(PortletContext portletCtx, DefaultCMSCustomizer customizer, CMSService cmsService) {
        this.cmsService = cmsService;
        this.portletCtx = portletCtx;
        this.customizer = customizer;
    }

    public void formatContentMenuBar(CMSServiceCtx cmsCtx) throws Exception {
        block9: {
            if (cmsCtx.getDoc() == null && cmsCtx.getCreationPath() == null) {
                return;
            }
            PortletRequest request = cmsCtx.getRequest();
            List menuBar = (List)request.getAttribute(MENU_BAR);
            try {
                if (cmsCtx.getDoc() != null) {
                    this.getPermaLinkLink(cmsCtx, menuBar);
                }
                if (cmsCtx.getDoc() != null) {
                    this.getContextualizationLink(cmsCtx, menuBar);
                }
                if (cmsCtx.getDoc() != null) {
                    this.getChangeModeLink(cmsCtx, menuBar);
                }
                if (cmsCtx.getDoc() != null) {
                    this.getEditLink(cmsCtx, menuBar);
                }
                this.getCreateLink(cmsCtx, menuBar);
                if (cmsCtx.getDoc() != null) {
                    this.getDeleteLink(cmsCtx, menuBar);
                }
                if (cmsCtx.getDoc() != null) {
                    this.getAdministrationLink(cmsCtx, menuBar);
                }
            }
            catch (CMSException e) {
                if (e.getErrorCode() == CMSException.ERROR_FORBIDDEN || e.getErrorCode() == CMSException.ERROR_NOTFOUND) break block9;
                throw e;
            }
        }
    }

    protected boolean isInLiveMode(CMSServiceCtx cmsCtx, CMSPublicationInfos pubInfos) {
        boolean liveMode = false;
        IContributionService.EditionState curState = (IContributionService.EditionState)cmsCtx.getRequest().getAttribute("osivia.editionState");
        if (curState != null && curState.getContributionMode().equals(IContributionService.EditionState.CONTRIBUTION_MODE_EDITION) && curState.getDocPath().equals(pubInfos.getDocumentPath())) {
            liveMode = true;
        }
        return liveMode;
    }

    protected boolean isRemoteProxy(CMSServiceCtx cmsCtx, CMSPublicationInfos pubInfos) {
        if (pubInfos.isPublished() && !this.isInLiveMode(cmsCtx, pubInfos)) {
            String docPath = ((Document)cmsCtx.getDoc()).getPath();
            if (pubInfos.getDocumentPath().equals(docPath)) {
                return true;
            }
        }
        return false;
    }

    protected void addAdministrationLinkItem(List<MenubarItem> menuBar, String url) throws Exception {
        MenubarItem item = new MenubarItem("MANAGE", "G\u00e9rer", MenubarItem.ORDER_PORTLET_SPECIFIC_CMS + 3, url, null, "portlet-menuitem-nuxeo-manage", "nuxeo");
        item.setAjaxDisabled(true);
        item.setDropdownItem(true);
        menuBar.add(item);
    }

    protected void getAdministrationLink(CMSServiceCtx cmsCtx, List<MenubarItem> menuBar) throws Exception {
        if (cmsCtx.getRequest().getRemoteUser() == null) {
            return;
        }
        CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(cmsCtx, ((Document)cmsCtx.getDoc()).getPath());
        if (this.isRemoteProxy(cmsCtx, pubInfos)) {
            return;
        }
        if (pubInfos.isEditableByUser() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsCtx)) {
            String url = NuxeoConnectionProperties.getPublicBaseUri().toString() + "/nxdoc/default/" + pubInfos.getLiveId() + "/view_documents";
            this.addAdministrationLinkItem(menuBar, url);
        }
    }

    protected void addChangeModeLinkItem(List<MenubarItem> menuBar, String url, IContributionService.EditionState newState) throws Exception {
        if (IContributionService.EditionState.CONTRIBUTION_MODE_EDITION.equals(newState.getContributionMode())) {
            MenubarItem liveView = new MenubarItem(null, "Voir la version de travail", MenubarItem.ORDER_PORTLET_SPECIFIC_CMS, url, null, "live", "");
            liveView.setAjaxDisabled(true);
            liveView.setDropdownItem(true);
            menuBar.add(liveView);
        } else {
            MenubarItem publishedView = new MenubarItem(null, "Voir la version publi\u00e9e", MenubarItem.ORDER_PORTLET_SPECIFIC_CMS, url, null, "published", "");
            publishedView.setAjaxDisabled(true);
            publishedView.setDropdownItem(true);
            menuBar.add(publishedView);
        }
    }

    protected void getChangeModeLink(CMSServiceCtx cmsCtx, List<MenubarItem> menuBar) throws Exception {
        if (cmsCtx.getRequest().getRemoteUser() == null) {
            return;
        }
        Document document = (Document)cmsCtx.getDoc();
        String path = document.getPath();
        CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(cmsCtx, path);
        if (pubInfos.isEditableByUser() && !pubInfos.isLiveSpace() && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsCtx)) {
            IContributionService.EditionState newState = new IContributionService.EditionState(IContributionService.EditionState.CONTRIBUTION_MODE_EDITION, path);
            PortalControllerContext portalCtx = new PortalControllerContext(cmsCtx.getPortletCtx(), cmsCtx.getRequest(), (PortletResponse)cmsCtx.getResponse());
            if (this.isInLiveMode(cmsCtx, pubInfos)) {
                newState = new IContributionService.EditionState(IContributionService.EditionState.CONTRIBUTION_MODE_ONLINE, path);
                MenubarItem liveIndicator = new MenubarItem(null, "Version de travail", MenubarItem.ORDER_PORTLET_SPECIFIC_CMS, null, null, "portlet-menuitem-edition live", null);
                liveIndicator.setStateItem(true);
                menuBar.add(liveIndicator);
            } else {
                this.getContributionService().removeWindowEditionState(portalCtx);
            }
            if (this.isRemoteProxy(cmsCtx, pubInfos)) {
                return;
            }
            String url = this.getContributionService().getChangeEditionStateUrl(portalCtx, newState);
            if (!IContributionService.EditionState.CONTRIBUTION_MODE_EDITION.equals(newState.getContributionMode())) {
                String publishUrl = this.getContributionService().getPublishContributionUrl(portalCtx, pubInfos.getDocumentPath());
                MenubarItem publishAction = new MenubarItem(null, "Publier", MenubarItem.ORDER_PORTLET_SPECIFIC_CMS + 12, publishUrl, null, "publish-action", "");
                publishAction.setAjaxDisabled(true);
                publishAction.setDropdownItem(true);
                menuBar.add(publishAction);
            }
            if (this.isInLiveMode(cmsCtx, pubInfos) && !pubInfos.isPublished()) {
                return;
            }
            this.addChangeModeLinkItem(menuBar, url, newState);
            CMSItemType cmsItemType = (CMSItemType)this.customizer.getCMSItemTypes().get(document.getType());
            if (cmsItemType != null && cmsItemType.isFolderish()) {
                HashMap<String, String> properties = new HashMap<String, String>(1);
                properties.put("osivia.browser.path", pubInfos.getDocumentPath());
                HashMap parameters = new HashMap(0);
                String browserUrl = this.getPortalUrlFactory().getStartPortletUrl(portalCtx, "osivia-portal-browser-portlet-instance", properties, parameters, true);
                MenubarItem browserItem = new MenubarItem(null, "Parcourir les versions de travail", MenubarItem.ORDER_PORTLET_SPECIFIC_CMS, browserUrl, null, "browser live fancyframe_refresh", "");
                browserItem.setAjaxDisabled(true);
                browserItem.setDropdownItem(true);
                menuBar.add(browserItem);
            }
        }
    }

    protected void addEditLinkItem(List<MenubarItem> menuBar, String onClick, String url) throws Exception {
        MenubarItem item = new MenubarItem("EDIT", "Modifier", MenubarItem.ORDER_PORTLET_SPECIFIC_CMS + 2, url, onClick, "fancyframe_refresh edition", "nuxeo");
        item.setAjaxDisabled(true);
        item.setDropdownItem(true);
        menuBar.add(item);
    }

    protected void getEditLink(CMSServiceCtx cmsCtx, List<MenubarItem> menuBar) throws Exception {
        if (cmsCtx.getRequest().getRemoteUser() == null) {
            return;
        }
        CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(cmsCtx, ((Document)cmsCtx.getDoc()).getPath());
        if (pubInfos.isEditableByUser() && (pubInfos.isLiveSpace() || this.isInLiveMode(cmsCtx, pubInfos)) && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsCtx)) {
            Document doc = (Document)cmsCtx.getDoc();
            CMSItemType cmsItemType = (CMSItemType)this.customizer.getCMSItemTypes().get(doc.getType());
            if (cmsItemType != null && cmsItemType.isSupportsPortalForms()) {
                String callBackURL = this.getPortalUrlFactory().getRefreshPageUrl(new PortalControllerContext(cmsCtx.getPortletCtx(), cmsCtx.getRequest(), (PortletResponse)cmsCtx.getResponse()));
                String onClick = "setCallbackParams(null, '" + callBackURL + "')";
                this.addEditLinkItem(menuBar, onClick, NuxeoConnectionProperties.getPublicBaseUri().toString() + "/nxpath/default" + pubInfos.getDocumentPath() + "@toutatice_edit");
            }
        }
    }

    protected void getCreateLink(CMSServiceCtx cmsCtx, List<MenubarItem> menuBar) throws Exception {
        if (cmsCtx.getRequest().getRemoteUser() == null) {
            return;
        }
        String creationType = cmsCtx.getCreationType();
        String creationPath = cmsCtx.getCreationPath();
        Document parentDoc = (Document)cmsCtx.getDoc();
        if (creationPath != null) {
            parentDoc = (Document)this.cmsService.getContent(cmsCtx, creationPath).getNativeItem();
        }
        CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(cmsCtx, parentDoc.getPath());
        if (creationPath != null || ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsCtx)) {
            Map subTypes = pubInfos.getSubTypes();
            ArrayList<SubType> portalDocsToCreate = new ArrayList<SubType>();
            Map managedTypes = this.customizer.getCMSItemTypes();
            CMSItemType containerDocType = (CMSItemType)managedTypes.get(parentDoc.getType());
            if (containerDocType != null) {
                for (String docType : subTypes.keySet()) {
                    CMSItemType docTypeDef;
                    if (!containerDocType.getPortalFormSubTypes().contains(docType) || creationType != null && !creationType.equals(docType) || (docTypeDef = (CMSItemType)managedTypes.get(docType)) == null || !docTypeDef.isSupportsPortalForms()) continue;
                    SubType subType = new SubType();
                    subType.setDocType(docType);
                    subType.setName((String)subTypes.get(docType));
                    subType.setUrl(NuxeoConnectionProperties.getPublicBaseUri().toString() + "/nxpath/default" + pubInfos.getDocumentPath() + "@toutatice_create?type=" + docType);
                    portalDocsToCreate.add(subType);
                }
            }
            String callBackURL = this.getPortalUrlFactory().getRefreshPageUrl(new PortalControllerContext(cmsCtx.getPortletCtx(), cmsCtx.getRequest(), (PortletResponse)cmsCtx.getResponse()));
            String onClick = "setCallbackParams(null, '" + callBackURL + "')";
            if (portalDocsToCreate.size() == 1) {
                String url = NuxeoConnectionProperties.getPublicBaseUri().toString() + "/nxpath/default" + pubInfos.getDocumentPath() + "@toutatice_create?type=" + ((SubType)portalDocsToCreate.get(0)).getDocType();
                MenubarItem add = new MenubarItem("CREATE", "Ajouter", MenubarItem.ORDER_PORTLET_SPECIFIC_CMS, url, onClick, "fancyframe_refresh portlet-menuitem-nuxeo-add", "nuxeo");
                add.setDropdownItem(true);
                add.setAjaxDisabled(true);
                menuBar.add(add);
                return;
            }
            String fancyID = null;
            if (portalDocsToCreate.size() > 0) {
                fancyID = "_PORTAL_CREATE";
            }
            if (fancyID != null) {
                StringBuffer fancyContent = new StringBuffer();
                fancyContent.append("<div class=\"fancybox-content\">");
                fancyContent.append("   <div id=\"" + cmsCtx.getResponse().getNamespace() + "_PORTAL_CREATE\" class=\"document-types\">");
                fancyContent.append("       <div class=\"main-doc-types\" id=\"" + cmsCtx.getResponse().getNamespace() + "_MAIN\">");
                fancyContent.append("           <div class=\"doc-type-title\">Ajouter un contenu</div>");
                int index = 1;
                int nbSubDocs = portalDocsToCreate.size();
                for (SubType subDoc : portalDocsToCreate) {
                    fancyContent.append("<div class=\"doc-type-detail\">");
                    fancyContent.append("   <div class=\"vignette\">");
                    fancyContent.append("       <a class=\"fancyframe_refresh\" href=\"" + subDoc.getUrl() + "\">");
                    fancyContent.append("           <img src=\"/toutatice-portail-cms-nuxeo/img/icons/" + subDoc.getDocType().toLowerCase() + "_100.png\"> ");
                    fancyContent.append("       </a>");
                    fancyContent.append("   </div>");
                    fancyContent.append("   <div class=\"main\">");
                    fancyContent.append("       <div class=\"title\">");
                    fancyContent.append("           <a class=\"fancyframe_refresh\" href=\"" + subDoc.getUrl() + "\">" + subDoc.getName() + "</a>");
                    fancyContent.append("       </div>");
                    fancyContent.append("   </div>");
                    fancyContent.append("</div>");
                    if (index < nbSubDocs) {
                        fancyContent.append("<div class=\"vertical-separator\"></div>");
                    }
                    ++index;
                }
                fancyContent.append("        </div>");
                fancyContent.append("   </div>");
                fancyContent.append("</div>");
                MenubarItem item = new MenubarItem("EDIT", "Ajouter ", MenubarItem.ORDER_PORTLET_SPECIFIC_CMS + 1, "#" + cmsCtx.getResponse().getNamespace() + fancyID, onClick, "fancybox_inline fancybox-no-title portlet-menuitem-nuxeo-add", "nuxeo");
                item.setAjaxDisabled(true);
                item.setAssociatedHtml(fancyContent.toString());
                item.setDropdownItem(true);
                menuBar.add(item);
            }
        }
    }

    protected void addDeleteLinkItem(List<MenubarItem> menuBar, String onClick, String url, String fancyContent) throws Exception {
        MenubarItem delete = new MenubarItem("DELETE", "Supprimer", MenubarItem.ORDER_PORTLET_SPECIFIC_CMS + 20, url, null, "fancybox_inline portlet-menuitem-nuxeo-delete", null);
        delete.setAjaxDisabled(true);
        delete.setAssociatedHtml(fancyContent);
        delete.setDropdownItem(true);
        menuBar.add(delete);
    }

    protected void getDeleteLink(CMSServiceCtx cmsCtx, List<MenubarItem> menuBar) throws Exception {
        CMSItemType docTypeDef;
        if (cmsCtx.getRequest().getRemoteUser() == null) {
            return;
        }
        Document doc = (Document)cmsCtx.getDoc();
        CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(cmsCtx, doc.getPath());
        if (this.isRemoteProxy(cmsCtx, pubInfos)) {
            return;
        }
        if (pubInfos.isDeletableByUser() && !this.isRemoteProxy(cmsCtx, pubInfos) && ContextualizationHelper.isCurrentDocContextualized((CMSServiceCtx)cmsCtx) && (docTypeDef = (CMSItemType)this.customizer.getCMSItemTypes().get(doc.getType())) != null && docTypeDef.isSupportsPortalForms()) {
            String fancyID = "_PORTAL_DELETE";
            StringBuffer fancyContent = new StringBuffer();
            fancyContent.append(" <div id=\"" + cmsCtx.getResponse().getNamespace() + fancyID + "\" class=\"fancybox-content\">");
            String putInTrashUrl = this.getPortalUrlFactory().getPutDocumentInTrashUrl(new PortalControllerContext(cmsCtx.getPortletCtx(), cmsCtx.getRequest(), (PortletResponse)cmsCtx.getResponse()), pubInfos.getLiveId(), pubInfos.getDocumentPath());
            fancyContent.append("   <form method=\"post\" action=\"" + putInTrashUrl + "\">");
            fancyContent.append("       <div>Confirmez-vous la suppression de l'\u00e9l\u00e9ment ?</div><br/>");
            fancyContent.append("       <input id=\"currentDocId\" type=\"hidden\" name=\"docId\" value=\"" + doc.getId() + "\"/>");
            fancyContent.append("       <input id=\"currentDocPath\" type=\"hidden\" name=\"docPath\" value=\"" + doc.getPath() + "\"/>");
            fancyContent.append("       <input type=\"submit\" name=\"deleteDoc\"  value=\"Confirmer\">");
            fancyContent.append("       <input type=\"reset\" name=\"noDeleteDoc\"  value=\"Annuler\" onclick=\"closeFancyBox();\">");
            fancyContent.append("   </form>");
            fancyContent.append(" </div>");
            this.addDeleteLinkItem(menuBar, null, "#" + cmsCtx.getResponse().getNamespace() + fancyID, fancyContent.toString());
        }
    }

    protected void addContextualizationLinkItem(List<MenubarItem> menuBar, String displayName, String url) throws Exception {
        MenubarItem item = new MenubarItem("CONTEXTUALIZE", "Espace " + displayName, MenubarItem.ORDER_PORTLET_SPECIFIC_CMS + 1, url, null, "portlet-menuitem-contextualize", null);
        item.setAjaxDisabled(true);
        menuBar.add(item);
    }

    protected void getContextualizationLink(CMSServiceCtx cmsCtx, List<MenubarItem> menuBar) throws Exception {
        Page page;
        if (!WindowState.MAXIMIZED.equals((Object)cmsCtx.getRequest().getWindowState())) {
            return;
        }
        PortalControllerContext portalCtx = new PortalControllerContext(cmsCtx.getPortletCtx(), cmsCtx.getRequest(), (PortletResponse)cmsCtx.getResponse());
        Page currentPage = null;
        Window window = (Window)cmsCtx.getRequest().getAttribute("osivia.window");
        if (window != null) {
            currentPage = window.getPage();
        }
        if ((page = this.getPortalUrlFactory().getPortalCMSContextualizedPage(portalCtx, ((Document)cmsCtx.getDoc()).getPath())) == null || !page.getId().equals((Object)currentPage.getId())) {
            String spaceDisplayName = null;
            if (page != null) {
                Locale locale = Locale.FRENCH;
                spaceDisplayName = page.getDisplayName().getString(locale, true);
                if (spaceDisplayName == null) {
                    spaceDisplayName = page.getName();
                }
            } else {
                CMSItem pubConfig;
                CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(cmsCtx, ((Document)cmsCtx.getDoc()).getPath());
                if (pubInfos.getPublishSpacePath() != null && "1".equals((pubConfig = this.cmsService.getSpaceConfig(cmsCtx, pubInfos.getPublishSpacePath())).getProperties().get("contextualizeInternalContents"))) {
                    spaceDisplayName = pubInfos.getPublishSpaceDisplayName();
                }
            }
            if (spaceDisplayName != null) {
                String url = this.getPortalUrlFactory().getCMSUrl(new PortalControllerContext(cmsCtx.getPortletCtx(), cmsCtx.getRequest(), (PortletResponse)cmsCtx.getResponse()), currentPage.getId().toString(PortalObjectPath.CANONICAL_FORMAT), ((Document)cmsCtx.getDoc()).getPath(), null, "portal", null, null, null, null, null);
                this.addContextualizationLinkItem(menuBar, spaceDisplayName, url);
            }
        }
    }

    protected void addPermaLinkItem(List<MenubarItem> menuBar, String url) throws Exception {
        MenubarItem item = new MenubarItem("PERMLINK", "Permalink", MenubarItem.ORDER_PORTLET_SPECIFIC_CMS, url, null, "portlet-menuitem-permalink", null);
        item.setAjaxDisabled(true);
        menuBar.add(item);
    }

    protected void getPermaLinkLink(CMSServiceCtx cmsCtx, List<MenubarItem> menuBar) throws Exception {
        if (!WindowState.MAXIMIZED.equals((Object)cmsCtx.getRequest().getWindowState())) {
            return;
        }
        String permaLinkURL = this.getPortalUrlFactory().getPermaLink(new PortalControllerContext(cmsCtx.getPortletCtx(), cmsCtx.getRequest(), (PortletResponse)cmsCtx.getResponse()), null, null, ((Document)cmsCtx.getDoc()).getPath(), "cms");
        if (permaLinkURL != null) {
            this.addPermaLinkItem(menuBar, permaLinkURL);
        }
    }

    public static MenubarItem getItemByType(String type, PortletRequest request) {
        MenubarItem searchItem = null;
        List menuBar = (List)request.getAttribute(MENU_BAR);
        boolean itemFound = false;
        Iterator items = menuBar.iterator();
        while (items.hasNext() && !itemFound) {
            MenubarItem item = (MenubarItem)items.next();
            if (!type.equalsIgnoreCase(item.getId())) continue;
            itemFound = true;
            searchItem = item;
        }
        return searchItem;
    }
}

