/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.IFragmentModule;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.RenderResponse;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSObjectPath;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.context.ControllerContextAdapter;

public class NavigationPictureFragmentModule
implements IFragmentModule {
    private Document computePicture(NuxeoController ctx, CMSServiceCtx navCtx, String propertyName) throws CMSException {
        Document pictureContainer = null;
        boolean hasPicture = false;
        String pathToCheck = ctx.getNavigationPath();
        CMSItem currentItem = ctx.getCMSService().getContent(navCtx, ctx.getContentPath());
        Document currentDoc = (Document)currentItem.getNativeItem();
        if (this.docHasPicture(currentDoc, propertyName)) {
            return currentDoc;
        }
        do {
            CMSItem cmsItemNav;
            if ((pictureContainer = (Document)(cmsItemNav = ctx.getCMSService().getPortalNavigationItem(navCtx, ctx.getSpacePath(), pathToCheck)).getNativeItem()) != null) {
                hasPicture = this.docHasPicture(pictureContainer, propertyName);
            }
            CMSObjectPath parentPath = CMSObjectPath.parse((String)pathToCheck).getParent();
            pathToCheck = parentPath.toString();
        } while (!hasPicture && pathToCheck.contains(ctx.getSpacePath()));
        if (hasPicture) {
            return pictureContainer;
        }
        return null;
    }

    private boolean docHasPicture(Document currentDoc, String propertyName) {
        PropertyMap picture = (PropertyMap)currentDoc.getProperties().get(propertyName);
        boolean hasPicture = picture != null && picture.get("data") != null;
        return hasPicture;
    }

    public void injectViewAttributes(NuxeoController ctx, PortalWindow window, PortletRequest request, RenderResponse response) throws Exception {
        Document navigationPictureContainer;
        boolean emptyResponse = true;
        CMSServiceCtx cmsReadNavContext = new CMSServiceCtx();
        cmsReadNavContext.setControllerContext(ControllerContextAdapter.getControllerContext((PortalControllerContext)ctx.getPortalCtx()));
        cmsReadNavContext.setScope(ctx.getNavigationScope());
        request.setAttribute("ctx", (Object)ctx);
        String propertyName = window.getProperty("osivia.propertyName");
        if (ctx.getNavigationPath() != null && propertyName != null && (navigationPictureContainer = this.computePicture(ctx, cmsReadNavContext, propertyName)) != null) {
            request.setAttribute("propertyName", (Object)propertyName);
            request.setAttribute("navigationPictureContainer", (Object)this.computePicture(ctx, cmsReadNavContext, propertyName));
            emptyResponse = false;
        }
        if (emptyResponse) {
            request.setAttribute("osivia.emptyResponse", (Object)"1");
        }
    }

    public void injectAdminAttributes(NuxeoController ctx, PortalWindow window, PortletRequest request, RenderResponse response) throws Exception {
        String propertyName = window.getProperty("osivia.propertyName");
        if (propertyName == null) {
            propertyName = "";
        }
        request.setAttribute("propertyName", (Object)propertyName);
    }

    public void processAdminAttributes(NuxeoController ctx, PortalWindow window, ActionRequest request, ActionResponse response) throws Exception {
        if (request.getParameter("propertyName") != null) {
            if (request.getParameter("propertyName").length() > 0) {
                window.setProperty("osivia.propertyName", request.getParameter("propertyName"));
            } else if (window.getProperty("osivia.propertyName") != null) {
                window.setProperty("osivia.propertyName", null);
            }
        }
    }
}

