/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import javax.portlet.WindowStateException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.page.PageProperties;

/*
 * Exception performing whole class analysis ignored.
 */
public class XSLFunctions {
    private static Log logger = LogFactory.getLog(XSLFunctions.class);
    private static DefaultCMSCustomizer customizer;
    CMSServiceCtx ctx;
    IPortalUrlFactory urlFactory;
    PortalControllerContext portalCtx;
    NuxeoController nuxeoCtx;
    private final Pattern scope = Pattern.compile(".*");
    private final Pattern ressourceExp = Pattern.compile("/nuxeo/([a-z]*)/default/([a-zA-Z0-9[-]&&[^/]]*)/files:files/([0-9]*)/(.*)");
    private final Pattern blobExp = Pattern.compile("/nuxeo/([a-z]*)/default/([a-zA-Z0-9[-]&&[^/]]*)/blobholder:([0-9]*)/(.*)");
    private final Pattern picturesExp = Pattern.compile("/nuxeo/nxpicsfile/default/([a-zA-Z0-9[-]&&[^/]]*)/(.*):content/(.*)");
    private final Pattern internalPictureExp = Pattern.compile("/nuxeo/([a-z]*)/default/([a-zA-Z0-9[-]&&[^/]]*)/ttc:images/([0-9]*)/(.*)");
    private final Pattern permaLinkExp = Pattern.compile("/nuxeo/nxdoc/default/([^/]*)/view_documents(.*)");
    private final Pattern documentExp = Pattern.compile("/nuxeo/([a-z]*)/default([^@]*)@view_documents(.*)");
    private final Pattern portalRefExp = Pattern.compile("http://([^/:]*)(:[0-9]*)?/([^/]*)(/auth/|/)pagemarker/([0-9]*)/(.*)");
    private Matcher portalMatcherReference = null;
    private static final String PORTAL_REF = "/portalRef?";
    private static final int PORTAL_REF_LG;
    private static List<URI> baseURIs;

    public XSLFunctions(DefaultCMSCustomizer _customizer, CMSServiceCtx ctx) {
        customizer = _customizer;
        this.ctx = ctx;
    }

    public IPortalUrlFactory getPortalUrlFactory() throws Exception {
        if (this.urlFactory == null) {
            this.urlFactory = (IPortalUrlFactory)this.ctx.getPortletCtx().getAttribute("UrlService");
        }
        return this.urlFactory;
    }

    public PortalControllerContext getPortalControllerContext() throws Exception {
        if (this.portalCtx == null) {
            this.portalCtx = new PortalControllerContext(this.ctx.getPortletCtx(), this.ctx.getRequest(), (PortletResponse)this.ctx.getResponse());
        }
        return this.portalCtx;
    }

    public NuxeoController getNuxeoController() throws Exception {
        if (this.nuxeoCtx == null) {
            this.nuxeoCtx = new NuxeoController(this.ctx.getRequest(), (PortletResponse)this.ctx.getResponse(), this.ctx.getPortletCtx());
        }
        return this.nuxeoCtx;
    }

    public static List<URI> getNuxeoBaseURIs() throws URISyntaxException {
        if (baseURIs == null) {
            XSLFunctions.setNuxeoBaseURIs();
        }
        return baseURIs;
    }

    public static synchronized void setNuxeoBaseURIs() throws URISyntaxException {
        if (baseURIs == null) {
            ArrayList<URI> tmpBaseURIs = new ArrayList<URI>();
            customizer.getNuxeoConnectionProps();
            tmpBaseURIs.add(NuxeoConnectionProperties.getPublicBaseUri());
            String altServers = System.getProperty("nuxeo.alternativeServerNames");
            if (altServers != null) {
                String[] serverToks;
                for (String serverTok : serverToks = altServers.split("\\|")) {
                    StringBuilder stringBuilder = new StringBuilder().append("http://").append(serverTok);
                    customizer.getNuxeoConnectionProps();
                    tmpBaseURIs.add(new URI(stringBuilder.append(NuxeoConnectionProperties.getNuxeoContext()).toString()));
                }
            }
            baseURIs = tmpBaseURIs;
        }
    }

    private int getMaxChars() {
        int maxChars = 0;
        try {
            if (this.ctx.getRequest().getAttribute("maxChars") != null) {
                maxChars = Integer.parseInt((String)this.ctx.getRequest().getAttribute("maxChars"));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return maxChars;
    }

    public String wysiwygDisplayMode() {
        String displayMode = "complet";
        if (this.getMaxChars() > 0 && WindowState.NORMAL.equals((Object)this.ctx.getRequest().getWindowState())) {
            displayMode = "partiel";
        }
        return displayMode;
    }

    public String maximizedLink() throws WindowStateException {
        PortletURL portletUrl = null;
        if (this.ctx.getResponse() instanceof RenderResponse) {
            portletUrl = this.ctx.getResponse().createRenderURL();
        } else if (this.ctx.getResponse() instanceof ResourceResponse) {
            portletUrl = ((ResourceResponse)this.ctx.getResponse()).createRenderURL();
        }
        portletUrl.setWindowState(WindowState.MAXIMIZED);
        return portletUrl.toString();
    }

    public String link(String link) {
        if (link.startsWith("#")) {
            return link;
        }
        return this.rewrite(link, true);
    }

    public static String transformPortalUrl(String orginalUrl, Matcher mResReference) throws Exception {
        Pattern expOrginial = Pattern.compile("http://([^/:]*)(:[0-9]*)?/" + mResReference.group(3) + "(/auth/|/)((pagemarker/[0-9]*/)?)(.*)");
        Matcher mResOriginal = expOrginial.matcher(orginalUrl);
        if (!mResOriginal.matches()) {
            throw new Exception("Not a portal URL !!!");
        }
        String transformedUrl = "";
        transformedUrl = "http://" + mResOriginal.group(1);
        if (StringUtils.isNotEmpty((String)mResOriginal.group(2))) {
            transformedUrl = transformedUrl + mResOriginal.group(2);
        }
        transformedUrl = transformedUrl + "/" + mResReference.group(3);
        transformedUrl = transformedUrl + mResReference.group(4);
        transformedUrl = transformedUrl + "pagemarker/";
        transformedUrl = transformedUrl + mResReference.group(5) + '/';
        transformedUrl = transformedUrl + mResOriginal.group(6);
        return transformedUrl;
    }

    public Matcher getPortalMatcherReference() throws Exception {
        if (this.portalMatcherReference == null) {
            String sampleUrl = this.getPortalUrlFactory().getCMSUrl(this.getPortalControllerContext(), null, "", null, null, null, null, null, null, null);
            Matcher mReference = this.portalRefExp.matcher(sampleUrl);
            if (mReference.matches()) {
                this.portalMatcherReference = mReference;
            } else {
                throw new Exception("reference is unmatchable");
            }
        }
        return this.portalMatcherReference;
    }

    private String rewrite(String link, boolean checkScope) {
        try {
            try {
                int iPortalRef = link.indexOf("/portalRef?");
                if (iPortalRef != -1) {
                    String[] paramsArray = link.substring(iPortalRef + PORTAL_REF_LG).split("&");
                    HashMap<String, String> params = new HashMap<String, String>();
                    for (String element : paramsArray) {
                        String[] values = element.split("=");
                        if (values.length != 2) continue;
                        params.put(values[0], values[1]);
                    }
                    if ("dynamicPage".equals(params.get("type"))) {
                        String portalName = "/" + (String)PageProperties.getProperties().getPagePropertiesMap().get("portalName");
                        String templatePath = (String)params.get("templatePath");
                        String pageName = (String)params.get("pageName");
                        if (pageName == null) {
                            pageName = "genericDynamicWindow";
                        }
                        HashMap dynaProps = new HashMap();
                        HashMap dynaParams = new HashMap();
                        String dynamicUrl = this.getPortalUrlFactory().getStartPageUrl(this.getPortalControllerContext(), portalName, pageName, templatePath, dynaProps, dynaParams);
                        return dynamicUrl;
                    }
                } else {
                    String rawPath;
                    int indiceRawPath;
                    Matcher mReference = this.getPortalMatcherReference();
                    if (link.startsWith("http://" + mReference.group(1)) && (indiceRawPath = link.indexOf("/", 7)) != -1 && (rawPath = link.substring(indiceRawPath)).length() > 1 && rawPath.substring(1).startsWith(mReference.group(3))) {
                        return XSLFunctions.transformPortalUrl((String)link, (Matcher)mReference);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (!link.startsWith("http")) {
                customizer.getNuxeoConnectionProps();
                if (!link.startsWith(NuxeoConnectionProperties.getNuxeoContext())) {
                    return link;
                }
            }
            String trim = link.trim().replace(" ", "%20");
            for (URI baseURI : XSLFunctions.getNuxeoBaseURIs()) {
                URI url = baseURI.resolve(trim);
                if (!url.getScheme().equals("http") && !url.getScheme().equals("https") || !url.getHost().equals(baseURI.getHost())) continue;
                String query = url.getRawPath();
                Matcher mRes = this.ressourceExp.matcher(query);
                if (mRes.matches() && mRes.groupCount() > 0) {
                    String uid = mRes.group(2);
                    if (this.ctx.getDoc() != null) {
                        uid = ((Document)this.ctx.getDoc()).getId();
                    }
                    String fileIndex = mRes.group(3);
                    return this.getNuxeoController().createAttachedFileLink(uid, fileIndex);
                }
                Matcher mResInternalPicture = this.internalPictureExp.matcher(query);
                if (mResInternalPicture.matches() && mResInternalPicture.groupCount() > 0) {
                    String uid = mResInternalPicture.group(2);
                    if (this.ctx.getDoc() != null) {
                        uid = ((Document)this.ctx.getDoc()).getId();
                    }
                    String pictureIndex = mResInternalPicture.group(3);
                    return this.getNuxeoController().createAttachedPictureLink(uid, pictureIndex);
                }
                Matcher mPictures = this.picturesExp.matcher(query);
                if (mPictures.matches() && mPictures.groupCount() > 0) {
                    String uid = mPictures.group(1);
                    String content = mPictures.group(2);
                    return this.getNuxeoController().createPictureLink(uid, content);
                }
                Matcher mDoc = this.documentExp.matcher(query);
                if (mDoc.matches()) {
                    if (mDoc.groupCount() > 0) {
                        String path = mDoc.group(2);
                        return this.getNuxeoController().getCMSLinkByPath(path, null).getUrl();
                    }
                    return url.toString();
                }
                Matcher permaDoc = this.permaLinkExp.matcher(query);
                if (permaDoc.matches()) {
                    if (permaDoc.groupCount() > 0) {
                        String id = permaDoc.group(1);
                        return this.getNuxeoController().getCMSLinkByPath(id, null).getUrl();
                    }
                    return url.toString();
                }
                Matcher mBlobExp = this.blobExp.matcher(query);
                if (mBlobExp.matches() && mBlobExp.groupCount() > 0) {
                    String uid = mBlobExp.group(2);
                    String blobIndex = mBlobExp.group(3);
                    return this.getNuxeoController().createAttachedBlobLink(uid, blobIndex);
                }
                return url.toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)("Link " + link + "generates " + e.getMessage()));
        }
        return link;
    }

    private boolean shouldRewrite(URI uri) {
        return this.scope.matcher(uri.toString()).matches();
    }

    public boolean equalsIgnoreCase(String s1, String s2) {
        if (s1 == s2) {
            return true;
        }
        if (s1 == null) {
            return false;
        }
        return s1.equalsIgnoreCase(s2);
    }

    static {
        PORTAL_REF_LG = "/portalRef?".length();
        baseURIs = null;
    }
}

