/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.IFragmentModule;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.Zoom;
import java.util.ArrayList;
import java.util.Collections;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.windows.PortalWindow;

public class ZoomFragmentModule
implements IFragmentModule {
    public static final String ID = "zoom_property";
    public static final String DESC = "Liste de zooms";
    public static final String JSP = "zoom";
    public static final String ADMIN_JSP = "zoom";
    private static final String REF_URI = "refURI";

    public void injectViewAttributes(NuxeoController ctx, PortalWindow window, PortletRequest request, RenderResponse response) throws Exception {
        String nuxeoPath = window.getProperty("osivia.cms.uri");
        boolean emptyContent = true;
        if (StringUtils.isNotEmpty((String)nuxeoPath)) {
            Document doc = ctx.fetchDocument(nuxeoPath = ctx.getComputedPath(nuxeoPath));
            if (doc.getTitle() != null) {
                response.setTitle(doc.getTitle());
            }
            String propertyName = "zl:zoomLink";
            String refURI = window.getProperty("osivia.refURI");
            String view = window.getProperty("osivia.cms.style");
            if (StringUtils.isNotEmpty((String)propertyName)) {
                PropertyList dataContents;
                Object content = doc.getProperties().get(propertyName);
                ArrayList<Zoom> zoomContents = new ArrayList<Zoom>();
                if (StringUtils.isNotEmpty((String)refURI) && content instanceof PropertyList && (dataContents = (PropertyList)content) != null && dataContents.size() > 0) {
                    for (int index = 0; index < dataContents.size(); ++index) {
                        PropertyMap mProperty = dataContents.getMap(index);
                        String refURIValue = (String)mProperty.get(REF_URI);
                        if (!refURI.equalsIgnoreCase(refURIValue)) continue;
                        Zoom zoom = new Zoom();
                        PropertyMap map = dataContents.getMap(index);
                        zoom.setDescription(map.getString("desc"));
                        zoom.setHref(map.getString("href"));
                        zoom.setOrder(Integer.valueOf(map.getLong("order").intValue()));
                        zoom.setTitle(map.getString("title"));
                        zoomContents.add(zoom);
                    }
                }
                if (zoomContents != null && zoomContents.size() > 0) {
                    Collections.sort(zoomContents);
                    ctx.setCurrentDoc(doc);
                    request.setAttribute("doc", (Object)doc);
                    request.setAttribute("ctx", (Object)ctx);
                    request.setAttribute("dataContent", zoomContents);
                    request.setAttribute("view", (Object)view);
                    emptyContent = false;
                }
            }
        }
        if (emptyContent) {
            request.setAttribute("osivia.emptyResponse", (Object)"1");
        }
    }

    public void injectAdminAttributes(NuxeoController ctx, PortalWindow window, PortletRequest request, RenderResponse response) throws Exception {
        String nuxeoPath = window.getProperty("osivia.cms.uri");
        if (nuxeoPath == null) {
            nuxeoPath = "";
        }
        request.setAttribute("nuxeoPath", (Object)nuxeoPath);
        request.setAttribute("propertyName", (Object)"zl:zoomLink");
        String scope = window.getProperty("osivia.cms.forcePublicationScope");
        request.setAttribute("scope", (Object)scope);
        String displayLiveVersion = window.getProperty("osivia.cms.displayLiveVersion");
        if (displayLiveVersion == null) {
            displayLiveVersion = "";
        }
        request.setAttribute("displayLiveVersion", (Object)displayLiveVersion);
    }

    public void processAdminAttributes(NuxeoController ctx, PortalWindow window, ActionRequest request, ActionResponse res) throws Exception {
        if (request.getParameter("nuxeoPath") != null) {
            window.setProperty("osivia.cms.uri", request.getParameter("nuxeoPath"));
        }
        if (request.getParameter("scope") != null && request.getParameter("scope").length() > 0) {
            window.setProperty("osivia.cms.forcePublicationScope", request.getParameter("scope"));
        } else if (window.getProperty("osivia.cms.forcePublicationScope") != null) {
            window.setProperty("osivia.cms.forcePublicationScope", null);
        }
        if (request.getParameter("displayLiveVersion") != null) {
            if ("1".equals(request.getParameter("displayLiveVersion"))) {
                window.setProperty("osivia.cms.displayLiveVersion", "1");
            } else if (window.getProperty("osivia.cms.displayLiveVersion") != null) {
                window.setProperty("osivia.cms.displayLiveVersion", null);
            }
        }
    }
}

