/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.files;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.portlets.files.FileBrowserComparator;
import fr.toutatice.portail.cms.nuxeo.portlets.files.FolderGetFilesCommand;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.WindowState;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSItemType;
import org.osivia.portal.core.cms.CMSPublicationInfos;

public class FileBrowserPortlet
extends CMSPortlet {
    private IBundleFactory bundleFactory;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        IInternationalizationService internationalizationService = (IInternationalizationService)this.getPortletContext().getAttribute("InternationalizationService");
        if (internationalizationService == null) {
            throw new PortletException("Internationalization service initialization error.");
        }
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws PortletException, IOException {
        try {
            Bundle bundle = this.bundleFactory.getBundle(resourceRequest.getLocale());
            if ("fileActions".equals(resourceRequest.getParameter("type"))) {
                NuxeoController ctx = new NuxeoController((PortletRequest)resourceRequest, null, this.getPortletContext());
                String id = resourceRequest.getResourceID();
                CMSPublicationInfos pubInfos = NuxeoController.getCMSService().getPublicationInfos(ctx.getCMSCtx(), id);
                StringBuffer sb = new StringBuffer();
                sb.append("<div>");
                int nbItems = 0;
                if (pubInfos.isEditableByUser()) {
                    Document doc = ctx.fetchDocument(id);
                    CMSItemType cmsItemType = (CMSItemType)ctx.getCMSItemTypes().get(doc.getType());
                    if (cmsItemType != null && cmsItemType.isSupportsPortalForms()) {
                        String refreshUrl = ctx.getPortalUrlFactory().getRefreshPageUrl(new PortalControllerContext(this.getPortletContext(), (PortletRequest)resourceRequest, (PortletResponse)resourceResponse));
                        String editLabel = bundle.getString("EDIT");
                        sb.append("<a class=\"fancyframe_refresh\" onClick=\"setCallbackParams(null, '").append(refreshUrl).append("')\" href=\"").append(ctx.getNuxeoPublicBaseUri()).append("/nxpath/default").append(pubInfos.getDocumentPath()).append("@toutatice_edit\">").append(editLabel).append("</a>");
                        ++nbItems;
                    }
                    if (nbItems > 0) {
                        sb.append("<br/>");
                    }
                    String manageLabel = bundle.getString("MANAGE");
                    sb.append("<a target=\"nuxeo\" href=\"").append(ctx.getNuxeoPublicBaseUri()).append("/nxdoc/default/").append(pubInfos.getLiveId()).append("/view_documents\">").append(manageLabel).append("</a>");
                    ++nbItems;
                }
                if (pubInfos.isDeletableByUser()) {
                    String deleteDivId = resourceResponse.getNamespace() + "delete-file-item";
                    String deleteFormId = resourceResponse.getNamespace() + "delete-file-form";
                    String deleteURL = ctx.getPortalUrlFactory().getPutDocumentInTrashUrl(new PortalControllerContext(this.getPortletContext(), (PortletRequest)resourceRequest, (PortletResponse)resourceResponse), pubInfos.getLiveId(), pubInfos.getDocumentPath());
                    String deleteLabel = bundle.getString("DELETE");
                    sb.append("<br/>");
                    sb.append("<a class=\"fancybox_inline\" href=\"#").append(deleteDivId).append("\" onclick=\"document.getElementById('").append(deleteFormId).append("').action ='").append(deleteURL).append("';\">").append(deleteLabel).append("</a>");
                    ++nbItems;
                }
                if (nbItems == 0) {
                    sb.append("<b>Aucune action<br/>disponible</b>");
                }
                sb.append("<div>");
                resourceResponse.getPortletOutputStream().write(sb.toString().getBytes());
                resourceResponse.getPortletOutputStream().close();
            } else {
                super.serveResource(resourceRequest, resourceResponse);
            }
        }
        catch (NuxeoException e) {
            this.serveResourceException(resourceRequest, resourceResponse, e);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void processAction(ActionRequest req, ActionResponse res) throws IOException, PortletException {
        logger.debug((Object)"processAction ");
        if ("admin".equals(req.getPortletMode().toString()) && req.getParameter("modifierPrefs") != null) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
            window.setProperty("osivia.nuxeoPath", req.getParameter("nuxeoPath"));
            res.setPortletMode(PortletMode.VIEW);
            res.setWindowState(WindowState.NORMAL);
        }
        if ("admin".equals(req.getPortletMode().toString()) && req.getParameter("annuler") != null) {
            res.setPortletMode(PortletMode.VIEW);
            res.setWindowState(WindowState.NORMAL);
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        res.setContentType("text/html");
        NuxeoController ctx = new NuxeoController((PortletRequest)req, (PortletResponse)res, this.getPortletContext());
        PortletRequestDispatcher rd = null;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
        String nuxeoPath = window.getProperty("osivia.nuxeoPath");
        if (nuxeoPath == null) {
            nuxeoPath = "";
        }
        req.setAttribute("nuxeoPath", (Object)nuxeoPath);
        req.setAttribute("ctx", (Object)ctx);
        rd = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/files/admin.jsp");
        rd.include(req, res);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, PortletSecurityException, IOException {
        block7: {
            logger.debug((Object)"doView");
            try {
                List sortedDocs;
                Document doc;
                NuxeoController ctx;
                response.setContentType("text/html");
                PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                String nuxeoPath = null;
                nuxeoPath = window.getProperty("osivia.cms.uri");
                if (nuxeoPath == null) {
                    nuxeoPath = window.getProperty("osivia.nuxeoPath");
                }
                if (nuxeoPath != null) {
                    ctx = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
                    ctx.setDisplayLiveVersion("1");
                    nuxeoPath = ctx.getComputedPath(nuxeoPath);
                    doc = ctx.fetchDocument(nuxeoPath);
                    CMSPublicationInfos pubInfos = NuxeoController.getCMSService().getPublicationInfos(ctx.getCMSCtx(), nuxeoPath);
                    Documents docs = (Documents)ctx.executeNuxeoCommand((INuxeoCommand)new FolderGetFilesCommand(pubInfos.getDocumentPath(), pubInfos.getLiveId()));
                    sortedDocs = docs.list();
                    CMSItemType cmsItemType = (CMSItemType)ctx.getCMSItemTypes().get(doc.getType());
                    if (cmsItemType == null || !cmsItemType.isOrdered()) {
                        Collections.sort(sortedDocs, new FileBrowserComparator(ctx));
                    }
                } else {
                    response.setContentType("text/html");
                    response.getWriter().print("<h2>Document non d\u00e9fini</h2>");
                    response.getWriter().close();
                    return;
                }
                request.setAttribute("docs", (Object)sortedDocs);
                ctx.setCurrentDoc(doc);
                ctx.insertContentMenuBarItems();
                request.setAttribute("basePath", (Object)nuxeoPath);
                request.setAttribute("folderPath", (Object)nuxeoPath);
                request.setAttribute("doc", (Object)doc);
                request.setAttribute("ctx", (Object)ctx);
                response.setTitle(doc.getTitle());
                this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/files/view.jsp").include(request, response);
            }
            catch (NuxeoException e) {
                PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
            }
            catch (Exception e) {
                if (e instanceof PortletException) break block7;
                throw new PortletException((Throwable)e);
            }
        }
        logger.debug((Object)"doView end");
    }
}

