/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.list;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

public class ListCommand
implements INuxeoCommand {
    String nuxeoRequest;
    int pageNumber;
    int pageSize;
    String schemas;
    boolean displayLiveVersion;
    String portalPolicyFilter;

    public ListCommand(String nuxeoRequest, boolean displayLiveVersion, int pageNumber, int pageSize, String schemas, String portalPolicyFilter) {
        this.nuxeoRequest = nuxeoRequest;
        this.displayLiveVersion = displayLiveVersion;
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.schemas = schemas;
        this.portalPolicyFilter = portalPolicyFilter;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        OperationRequest request = nuxeoSession.newRequest("Document.PageProvider");
        request.set("pageSize", (Object)this.pageSize);
        request.set("page", (Object)this.pageNumber);
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((String)this.nuxeoRequest, (boolean)this.displayLiveVersion, (String)this.portalPolicyFilter);
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredRequest));
        request.setHeader("X-NXDocumentProperties", this.schemas);
        return request.execute();
    }

    public String getId() {
        return "ListCommand/" + this.displayLiveVersion + "/" + this.pageSize + "/" + this.pageNumber + "/" + this.nuxeoRequest;
    }
}

