/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.list;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyEntry;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.selectors.DateSelectorPortlet;
import fr.toutatice.portail.cms.nuxeo.portlets.selectors.VocabSelectorPortlet;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;

public class NXQLFormater {
    private static final String FRONTEND_DATE_PATTERN = "dd/MM/yyyy";
    private static final String BACKEND_DATE_PATTERN = "yyyy-MM-dd";

    public String formatTextSearch(String fieldName, List<String> searchValues) {
        StringBuffer request = new StringBuffer();
        request.append("(");
        boolean firstItem = true;
        for (String searchWord : searchValues) {
            if (!firstItem) {
                request.append(" OR ");
            }
            request.append(fieldName + " ILIKE \"%" + searchWord + "%\"");
            firstItem = false;
        }
        request.append(")");
        return request.toString();
    }

    public String formatVocabularySearch(String fieldName, List<String> selectedVocabsEntries) {
        StringBuffer clause = new StringBuffer();
        clause.append("(");
        boolean firstItem = true;
        for (String selectedVocabsEntry : selectedVocabsEntries) {
            if (selectedVocabsEntry.contains(VocabSelectorPortlet.OTHER_ENTRIES_CHOICE)) continue;
            if (!firstItem) {
                clause.append(" OR ");
            }
            clause.append(fieldName + " STARTSWITH '" + selectedVocabsEntry + "'");
            firstItem = false;
        }
        clause.append(")");
        return clause.toString();
    }

    public String formatOthersVocabularyEntriesSearch(PortletRequest portletRequest, List<?> vocabsNames, String fieldName, List<String> selectedVocabsEntries) throws Exception {
        String resultClause;
        StringBuffer clause = new StringBuffer();
        int nbOtherEntries = 0;
        for (String selectedEntry : selectedVocabsEntries) {
            if (!selectedEntry.contains(VocabSelectorPortlet.OTHER_ENTRIES_CHOICE)) continue;
            if (nbOtherEntries > 0) {
                clause.append(" OR ");
            }
            ++nbOtherEntries;
            StringBuffer clauseBeforeOther = new StringBuffer();
            StringBuffer otherClause = new StringBuffer();
            String selectedValuesBeforeOthers = StringUtils.substringBeforeLast((String)selectedEntry, (String)"/");
            selectedValuesBeforeOthers = VocabSelectorPortlet.OTHER_ENTRIES_CHOICE.equalsIgnoreCase(selectedValuesBeforeOthers) ? "" : selectedValuesBeforeOthers + "/";
            if (StringUtils.isNotEmpty((String)selectedValuesBeforeOthers)) {
                clauseBeforeOther.append(" ( ");
                clauseBeforeOther.append(fieldName);
                clauseBeforeOther.append(" STARTSWITH '");
                clauseBeforeOther.append(selectedValuesBeforeOthers);
                clauseBeforeOther.append("' ");
                clauseBeforeOther.append(") AND ");
            }
            int selectedLevel = selectedEntry.split("/").length;
            ArrayList<String> vocabNames = new ArrayList<String>();
            for (Object vocab : vocabsNames) {
                vocabNames.add(vocab.toString());
            }
            VocabularyEntry vocabEntry = VocabularyHelper.getVocabularyEntry((NuxeoController)((NuxeoController)portletRequest.getAttribute("ctx")), vocabNames);
            VocabularyEntry lastVocab = vocabEntry;
            String[] entries = selectedEntry.split("/");
            for (int levelIndex = 0; levelIndex < selectedLevel; ++levelIndex) {
                String entry = entries[levelIndex];
                if (VocabSelectorPortlet.OTHER_ENTRIES_CHOICE.equals(entry)) continue;
                lastVocab = lastVocab.getChild(entry);
            }
            Collection vocabsEntries = lastVocab.getChildren().values();
            if (vocabsEntries != null && vocabsEntries.size() > 0) {
                otherClause.append(" ( NOT (");
                boolean firstItem = true;
                for (VocabularyEntry displayedEntry : vocabsEntries) {
                    String entry = displayedEntry.getId();
                    if (!firstItem) {
                        otherClause.append(" OR ");
                    }
                    otherClause.append(fieldName);
                    otherClause.append(" STARTSWITH '");
                    otherClause.append(selectedValuesBeforeOthers);
                    otherClause.append(entry);
                    otherClause.append("' ");
                    firstItem = false;
                }
                otherClause.append(" ) ) ");
            }
            clause.append(clauseBeforeOther.toString());
            clause.append(otherClause.toString());
        }
        StringBuffer otherClause = new StringBuffer();
        if (nbOtherEntries > 0) {
            otherClause.append("(");
            otherClause.append(clause.toString());
            otherClause.append(")");
        }
        if ((resultClause = this.formatVocabularySearch(fieldName, selectedVocabsEntries)).equals("()")) {
            resultClause = "";
        }
        if (nbOtherEntries > 0) {
            resultClause = resultClause.length() > 0 ? "(" + resultClause + " OR " + otherClause.toString() + ")" : otherClause.toString();
        }
        return resultClause;
    }

    public String formatDateSearch(String fieldName, List<String> searchValue) {
        StringBuffer request = new StringBuffer();
        if (searchValue != null && searchValue.size() > 0) {
            request.append("(");
            int index = 0;
            for (String datesInterval : searchValue) {
                String[] interval = datesInterval.split(DateSelectorPortlet.DATES_SEPARATOR);
                try {
                    String[] frontPattern = new String[]{FRONTEND_DATE_PATTERN};
                    Date beginDate = DateUtils.parseDate((String)interval[0], (String[])frontPattern);
                    Date endDate = DateUtils.parseDate((String)interval[1], (String[])frontPattern);
                    endDate = DateUtils.addDays((Date)endDate, (int)1);
                    String from = DateFormatUtils.format((Date)beginDate, (String)BACKEND_DATE_PATTERN);
                    String to = DateFormatUtils.format((Date)endDate, (String)BACKEND_DATE_PATTERN);
                    if (index > 0) {
                        request.append(" OR ");
                    }
                    request.append("(");
                    request.append(fieldName);
                    request.append(" BETWEEN DATE '");
                    request.append(from);
                    request.append("' AND DATE '");
                    request.append(to);
                    request.append("')");
                }
                catch (ParseException e) {
                    continue;
                }
                ++index;
            }
            request.append(")");
        }
        return request.toString();
    }

    public String formatAdvancedSearch(List<String> searchValues) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("ecm:fulltext = '");
        buffer.append(StringUtils.join(searchValues, (String)" "));
        buffer.append(" -noindex'");
        return NuxeoQueryFilter.addPublicationFilter((String)buffer.toString(), (boolean)false);
    }
}

