/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.publish;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoService;
import fr.toutatice.portail.cms.nuxeo.portlets.publish.MenuComparator;
import fr.toutatice.portail.cms.nuxeo.portlets.publish.NavigationDisplayItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSecurityException;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.common.invocation.InvocationContext;
import org.jboss.portal.core.controller.ControllerContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSItemType;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.context.ControllerContextAdapter;
import org.osivia.portal.core.security.CmsPermissionHelper;

public class MenuPortlet
extends CMSPortlet {
    private static Log logger = LogFactory.getLog(MenuPortlet.class);
    private IPortalUrlFactory portalUrlFactory;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        this.portalUrlFactory = (IPortalUrlFactory)this.getPortletContext().getAttribute("UrlService");
        if (this.portalUrlFactory == null) {
            throw new PortletException("Cannot start TestPortlet due to service unavailability");
        }
    }

    public void processAction(ActionRequest req, ActionResponse res) throws IOException, PortletException {
        logger.debug((Object)"processAction ");
        if ("admin".equals(req.getPortletMode().toString()) && req.getParameter("modifierPrefs") != null) {
            PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
            int openLevels = 0;
            if (req.getParameter("openLevels") != null) {
                try {
                    openLevels = Integer.parseInt(req.getParameter("openLevels"));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (openLevels > 0) {
                window.setProperty("osivia.cms.openLevels", Integer.toString(openLevels));
            } else if (window.getProperty("osivia.cms.openLevels") != null) {
                window.setProperty("osivia.cms.openLevels", null);
            }
            int maxLevels = 0;
            if (req.getParameter("maxLevels") != null) {
                try {
                    maxLevels = Integer.parseInt(req.getParameter("maxLevels"));
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (maxLevels > 0) {
                window.setProperty("osivia.cms.maxLevels", Integer.toString(maxLevels));
            } else if (window.getProperty("osivia.cms.maxLevels") != null) {
                window.setProperty("osivia.cms.maxLevels", null);
            }
            res.setPortletMode(PortletMode.VIEW);
            res.setWindowState(WindowState.NORMAL);
        }
        if ("admin".equals(req.getPortletMode().toString()) && req.getParameter("annuler") != null) {
            res.setPortletMode(PortletMode.VIEW);
            res.setWindowState(WindowState.NORMAL);
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest req, RenderResponse res) throws IOException, PortletException {
        res.setContentType("text/html");
        NuxeoController ctx = new NuxeoController((PortletRequest)req, (PortletResponse)res, this.getPortletContext());
        PortletRequestDispatcher rd = null;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)req);
        String openLevels = window.getProperty("osivia.cms.openLevels");
        req.setAttribute("openLevels", (Object)openLevels);
        String maxLevels = window.getProperty("osivia.cms.maxLevels");
        req.setAttribute("maxLevels", (Object)maxLevels);
        req.setAttribute("ctx", (Object)ctx);
        rd = this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/publish/admin.jsp");
        rd.include(req, res);
    }

    private NavigationDisplayItem createServiceItem(NuxeoController ctx, CMSServiceCtx cmsReadNavContext, PortalControllerContext portalCtx, int curLevel, int maxLevel, String spacePath, String basePath, String nuxeoPath, boolean isParentNavigable, int partialOpenLevels) throws Exception {
        ArrayList<NavigationDisplayItem> displayChildren;
        NavigationDisplayItem displayItem;
        Document doc;
        block11: {
            CMSItem navItem;
            block10: {
                INuxeoService nuxeoService = (INuxeoService)ctx.getPortletCtx().getAttribute("NuxeoService");
                navItem = ctx.getCMSService().getPortalNavigationItem(cmsReadNavContext, spacePath, nuxeoPath);
                if (navItem == null) {
                    return null;
                }
                doc = (Document)navItem.getNativeItem();
                String navPath = navItem.getPath();
                Link link = ctx.getLink(doc, "menu");
                boolean selected = false;
                String itemPath = ctx.getItemNavigationPath();
                if (itemPath != null) {
                    if ((itemPath = itemPath + "/").startsWith(navPath + "/") && isParentNavigable) {
                        selected = true;
                    } else if (ctx.getItemNavigationPath().equals(doc.getPath())) {
                        selected = true;
                    }
                }
                displayItem = new NavigationDisplayItem(doc.getTitle(), link.getUrl(), link.isExternal(), selected, navItem);
                displayChildren = new ArrayList<NavigationDisplayItem>();
                if (partialOpenLevels == -1 && curLevel + 1 <= maxLevel) break block10;
                if (partialOpenLevels == -1) break block11;
                if (selected) break block10;
                if (curLevel + 1 > partialOpenLevels) break block11;
            }
            List navItems = ctx.getCMSService().getPortalNavigationSubitems(cmsReadNavContext, basePath, nuxeoPath);
            for (CMSItem child : navItems) {
                NavigationDisplayItem newItem;
                if (!"1".equals(child.getProperties().get("menuItem")) || (newItem = this.createServiceItem(ctx, cmsReadNavContext, portalCtx, curLevel + 1, maxLevel, spacePath, basePath, child.getPath(), "1".equals(navItem.getProperties().get("navigationElement")), partialOpenLevels)) == null) continue;
                displayChildren.add(newItem);
            }
        }
        ArrayList sortedDocs = (ArrayList)displayChildren.clone();
        CMSItemType cmsItemType = (CMSItemType)ctx.getCMSItemTypes().get(doc.getType());
        if (cmsItemType == null || !cmsItemType.isOrdered()) {
            Collections.sort(sortedDocs, new MenuComparator(ctx));
        }
        displayItem.setChildrens((List)sortedDocs);
        return displayItem;
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, PortletSecurityException, IOException {
        block12: {
            logger.debug((Object)"doView");
            try {
                int openLevels;
                response.setContentType("text/html");
                PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                Object nuxeoPath = null;
                NuxeoController ctx = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
                String basePath = ctx.getBasePath();
                String spacePath = ctx.getSpacePath();
                String menuRootPath = ctx.getMenuRootPath();
                if (menuRootPath != null) {
                    basePath = menuRootPath;
                    spacePath = menuRootPath;
                }
                if (basePath != null) {
                    NavigationDisplayItem displayItem;
                    ctx.setAsynchronousUpdates(true);
                    int maxLevels = 3;
                    String sMaxLevels = window.getProperty("osivia.cms.maxLevels");
                    if (sMaxLevels != null && sMaxLevels.length() > 0) {
                        maxLevels = Integer.parseInt(sMaxLevels);
                    }
                    openLevels = 1;
                    String sOpenLevels = window.getProperty("osivia.cms.openLevels");
                    if (sOpenLevels != null && sOpenLevels.length() > 0) {
                        openLevels = Integer.parseInt(sOpenLevels);
                    }
                    CMSServiceCtx cmsReadNavContext = new CMSServiceCtx();
                    ControllerContext context = ControllerContextAdapter.getControllerContext((PortalControllerContext)ctx.getPortalCtx());
                    cmsReadNavContext.setControllerContext(context);
                    cmsReadNavContext.setScope(ctx.getNavigationScope());
                    if (CmsPermissionHelper.getCurrentCmsVersion((InvocationContext)context).equals("preview")) {
                        cmsReadNavContext.setDisplayLiveVersion("1");
                    }
                    int partialOpenLevels = -1;
                    CMSItem navItem = ctx.getCMSService().getPortalNavigationItem(cmsReadNavContext, basePath, basePath);
                    if ("1".equals(navItem.getProperties().get("partialLoading"))) {
                        partialOpenLevels = openLevels;
                    }
                    if ((displayItem = this.createServiceItem(ctx, cmsReadNavContext, new PortalControllerContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response), 0, maxLevels, spacePath, basePath, basePath, true, partialOpenLevels)) != null) {
                        if (displayItem.getTitle() != null) {
                            response.setTitle(displayItem.getTitle());
                        }
                        request.setAttribute("itemToDisplay", (Object)displayItem);
                    }
                } else {
                    response.setContentType("text/html");
                    response.getWriter().print("<h2>Path de la page non d\u00e9fini</h2>");
                    response.getWriter().close();
                    return;
                }
                request.setAttribute("openLevels", (Object)openLevels);
                request.setAttribute("ctx", (Object)ctx);
                this.getPortletContext().getRequestDispatcher("/WEB-INF/jsp/publish/view.jsp").include(request, response);
            }
            catch (NuxeoException e) {
                PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
            }
            catch (Exception e) {
                if (e instanceof PortletException) break block12;
                throw new PortletException((Throwable)e);
            }
        }
        logger.debug((Object)"doView end");
    }
}

