/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.search;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CMSCustomizer;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.PaginableDocuments;

public class SearchCommand
implements INuxeoCommand {
    String path;
    String keywords;
    int pageNumber;
    boolean displayLiveVersion;

    public SearchCommand(String path, boolean displayLiveVersion, String keywords, int pageNumber) {
        this.path = path;
        this.keywords = keywords;
        this.pageNumber = pageNumber;
        this.displayLiveVersion = displayLiveVersion;
    }

    private String addClause(String request, String clause) {
        String result = request;
        result = request.length() == 0 ? "WHERE " : result + " AND ";
        result = result + clause;
        return result;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        String searchKeywords;
        OperationRequest request = nuxeoSession.newRequest("Document.PageProvider");
        String searchQuery = "";
        if (this.path != null && this.path.length() > 0) {
            searchQuery = this.addClause(searchQuery, "ecm:path STARTSWITH '" + this.path + "'");
        }
        if ((searchKeywords = this.keywords) == null) {
            searchKeywords = "";
        }
        searchKeywords = searchKeywords + " -noindex";
        searchQuery = this.addClause(searchQuery, "ecm:fulltext = '" + searchKeywords + "'");
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((String)searchQuery, (boolean)this.displayLiveVersion);
        request.set("query", (Object)("SELECT * FROM Document " + filteredRequest));
        request.set("pageSize", (Object)5);
        request.set("page", (Object)this.pageNumber);
        request.setHeader("X-NXDocumentProperties", CMSCustomizer.getSearchSchema());
        PaginableDocuments result = (PaginableDocuments)request.execute();
        return result;
    }

    public String getId() {
        return "SearchCommand/" + this.displayLiveVersion + "/" + this.path + "/" + this.keywords;
    }
}

