/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Documents;

public class DocumentGetMediaLibraryCommand
implements INuxeoCommand {
    String path;

    public DocumentGetMediaLibraryCommand(String path) {
        this.path = path;
    }

    public Object execute(Session session) throws Exception {
        OperationRequest request = session.newRequest("Document.Query");
        String nuxeoRequest = "ecm:path STARTSWITH '" + this.path + "' AND ecm:primaryType = 'MediaLibrary' ORDER BY ecm:pos";
        boolean displayLiveVersion = true;
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((String)nuxeoRequest, (boolean)displayLiveVersion, (String)"global");
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredRequest));
        request.setHeader("X-NXDocumentProperties", "dublincore");
        Documents children = (Documents)request.execute();
        if (children.size() == 1) {
            return children.get(0);
        }
        return null;
    }

    public String getId() {
        return "DocumentGetMediaLibraryCommand/" + this.path;
    }

    public String getPath() {
        return this.path;
    }
}

