/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.io.InputStream;
import net.sf.json.JSONArray;
import org.apache.commons.io.IOUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blob;

public class ListCMSSubitemsCommand
implements INuxeoCommand {
    private final String parentId;
    private final boolean liveContent;

    public ListCMSSubitemsCommand(String parentId, boolean liveContent) {
        this.parentId = parentId;
        this.liveContent = liveContent;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        OperationRequest request = nuxeoSession.newRequest("Fetch.PublishingStatusChildren");
        request.set("documentId", (Object)this.parentId);
        request.set("liveStatus", (Object)this.liveContent);
        request.setHeader("X-NXDocumentProperties", this.getSchemas());
        Blob binariesPublishingInfos = (Blob)request.execute();
        String publishingInfos = IOUtils.toString((InputStream)binariesPublishingInfos.getStream(), (String)"UTF-8");
        return JSONArray.fromObject((Object)publishingInfos);
    }

    public String getId() {
        StringBuilder id = new StringBuilder();
        id.append(this.getClass().getCanonicalName());
        id.append("[");
        id.append(this.parentId);
        id.append(";");
        id.append(this.liveContent);
        id.append("]");
        return id.toString();
    }

    private String getSchemas() {
        return "dublincore, common, toutatice";
    }
}

