/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.NavigationItem;

public class PartialNavigationCommand
implements INuxeoCommand {
    CMSItem publishSpaceConfig;
    Map<String, NavigationItem> navItems;
    List<String> docIds;
    public static final String basicNavigationSchemas = "dublincore,common, toutatice";
    boolean fetchRoot = false;
    String commandPath;

    public PartialNavigationCommand(CMSItem publishSpaceConfig, Map<String, NavigationItem> navItems, List<String> docIds, boolean fetchRoot, String commandPath) {
        this.publishSpaceConfig = publishSpaceConfig;
        this.navItems = navItems;
        this.docIds = docIds;
        this.fetchRoot = fetchRoot;
        this.commandPath = commandPath;
    }

    public Object execute(Session session) throws Exception {
        NavigationItem navItem;
        String path = this.publishSpaceConfig.getPath();
        OperationRequest request = session.newRequest("Document.Query");
        String itemRequest = "";
        if (this.fetchRoot) {
            itemRequest = "ecm:uuid ='" + ((Document)this.publishSpaceConfig.getNativeItem()).getId() + "'";
        }
        for (String docId : this.docIds) {
            if (itemRequest.length() > 0) {
                itemRequest = itemRequest + " OR";
            }
            itemRequest = itemRequest + " ecm:parentId = '" + docId + "'";
        }
        String nuxeoRequest = "( " + itemRequest + ")  AND  (ecm:mixinType = 'Folderish' OR ttc:showInMenu = 1) ";
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((String)nuxeoRequest, (boolean)true, (String)"none");
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredRequest + " ORDER BY ecm:pos"));
        String navigationSchemas = basicNavigationSchemas;
        String extraNavigationSchemas = System.getProperty("nuxeo.navigationSchemas");
        if (extraNavigationSchemas != null) {
            navigationSchemas = navigationSchemas + "," + extraNavigationSchemas;
        }
        request.setHeader("X-NXDocumentProperties", navigationSchemas);
        Documents children = (Documents)request.execute();
        for (Document child : children) {
            String navPath = child.getPath();
            navItem = (NavigationItem)this.navItems.get(child.getPath());
            if (navItem == null) {
                navItem = new NavigationItem();
                navItem.setUnfetchedChildren(true);
                this.navItems.put(navPath, navItem);
            }
            navItem.setMainDoc((Object)child);
            String parentPath = navPath.substring(0, navPath.lastIndexOf(47));
            if (!parentPath.contains(path)) continue;
            navItem = (NavigationItem)this.navItems.get(parentPath);
            if (navItem == null) {
                navItem = new NavigationItem();
                this.navItems.put(parentPath, navItem);
            }
            boolean isAlreadyAChild = false;
            for (Object iChild : navItem.getChildren()) {
                Document childDoc = (Document)iChild;
                if (!childDoc.getPath().equals(child.getPath())) continue;
                isAlreadyAChild = true;
            }
            if (isAlreadyAChild) continue;
            navItem.getChildren().add(child);
        }
        for (Map.Entry navItemEntry : this.navItems.entrySet()) {
            Document doc;
            navItem = (NavigationItem)navItemEntry.getValue();
            if (!navItem.isUnfetchedChildren() || (doc = (Document)navItem.getMainDoc()) == null || !this.docIds.contains(doc.getId())) continue;
            navItem.setUnfetchedChildren(false);
        }
        return this.navItems;
    }

    public String getId() {
        return "PartialNavigationCommand/" + this.commandPath;
    }
}

