/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.service.editablewindow;

import fr.toutatice.portail.cms.nuxeo.service.editablewindow.EditableWindow;
import fr.toutatice.portail.cms.nuxeo.service.editablewindow.EditableWindowHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

public class ZoomEditableWindow
extends EditableWindow {
    public static final String ZOOM_SCHEMA = "zfgt:zoomFragment";
    public static final String ZOOM_LINKS = "zl:zoomLink";

    public ZoomEditableWindow(String instancePortlet, String prefixWindow) {
        super(instancePortlet, prefixWindow);
    }

    public Map<String, String> fillProps(Document doc, PropertyMap fragment, Boolean modeEditionPage) {
        Map propsFilled = super.fillGenericProps(doc, fragment, modeEditionPage);
        propsFilled.put("osivia.cms.uri", doc.getPath());
        PropertyMap mapListe = EditableWindowHelper.findSchemaByRefURI((Document)doc, (String)ZOOM_SCHEMA, (String)fragment.getString("uri"));
        propsFilled.put("osivia.cms.style", mapListe.getString("view"));
        propsFilled.put("osivia.fragmentTypeId", "zoom_property");
        propsFilled.put("osivia.propertyName", ZOOM_LINKS);
        return propsFilled;
    }

    public List<String> prepareDelete(Document doc, String refURI) {
        ArrayList<String> propertiesToRemove = new ArrayList<String>();
        this.prepareDeleteGeneric(propertiesToRemove, doc, refURI);
        Integer findIndexByRefURI = EditableWindowHelper.findIndexByRefURI((Document)doc, (String)ZOOM_SCHEMA, (String)refURI);
        propertiesToRemove.add(ZOOM_SCHEMA.concat("/").concat(findIndexByRefURI.toString()));
        List findIndexesByRefURI = EditableWindowHelper.findIndexesByRefURI((Document)doc, (String)ZOOM_LINKS, (String)refURI);
        for (Integer indexToRemove : findIndexesByRefURI) {
            propertiesToRemove.add(ZOOM_LINKS.concat("/").concat(indexToRemove.toString()));
        }
        Collections.reverse(propertiesToRemove);
        return propertiesToRemove;
    }
}

