/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer;

import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CustomMenuBarFormater;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CustomNavigationItemAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.MenuBarFormater;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.NavigationItemAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSHandlerProperties;
import org.osivia.portal.core.cms.CMSItemType;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;

public class CMSCustomizer
extends DefaultCMSCustomizer {
    public static final String SCHEMAS_SEARCH = "dublincore, common, file, uid, toutatice";
    public static final String SCHEMAS_ZOOM = "dublincore, toutatice, zoom";
    public static final String SCHEMAS_BLOG = "dublincore, common, toutatice, webpage";
    public static final String SCHEMAS_ANNONCE = "dublincore, common, toutatice, annonce, note";
    public static final String FORUM_SCHEMAS = "dublincore, common, toutatice, file, thread_toutatice";
    public static final String STYLE_TILE = "tuile";
    public static final String STYLE_BLOG = "blog";
    public static final String STYLE_WORKSPACE = "workspace";
    public static final String STYLE_FORUM = "forum";
    public NavigationItemAdapter navigationItemAdapter;
    private MenuBarFormater menuBarFormater;
    private Map<String, CMSItemType> customCMSItemTypes;

    public CMSCustomizer(PortletContext ctx) {
        super(ctx);
    }

    public NavigationItemAdapter getNavigationItemAdapter() {
        if (this.navigationItemAdapter == null) {
            this.navigationItemAdapter = new CustomNavigationItemAdapter(this.getPortletCtx(), (DefaultCMSCustomizer)this, this.getCmsService());
        }
        return this.navigationItemAdapter;
    }

    public MenuBarFormater getMenuBarFormater() {
        if (this.menuBarFormater == null) {
            this.menuBarFormater = new CustomMenuBarFormater(this.getPortletCtx(), (DefaultCMSCustomizer)this, this.getCmsService());
        }
        return this.menuBarFormater;
    }

    public List<ListTemplate> getListTemplates(Locale locale) {
        List templates = super.getListTemplates(locale);
        Bundle bundle = this.getBundleFactory().getBundle(locale);
        templates.add(new ListTemplate(STYLE_TILE, bundle.getString("LIST_TEMPLATE_TILES"), SCHEMAS_ZOOM));
        templates.add(new ListTemplate(STYLE_BLOG, bundle.getString("LIST_TEMPLATE_BLOG"), SCHEMAS_BLOG));
        templates.add(new ListTemplate(STYLE_WORKSPACE, bundle.getString("LIST_TEMPLATE_WORKSPACE"), "dublincore, common, toutatice, file"));
        templates.add(new ListTemplate(STYLE_FORUM, bundle.getString("LIST_TEMPLATE_FORUM"), FORUM_SCHEMAS));
        return templates;
    }

    public CMSHandlerProperties getCMSDefaultPlayer(CMSServiceCtx ctx) throws CMSException {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.uri", doc.getPath());
        windowProperties.put("osivia.cms.publishPathAlreadyConverted", "1");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewDocumentPortletInstance");
        return linkProps;
    }

    public CMSHandlerProperties getCMSPlayer(CMSServiceCtx cmsContext) throws Exception {
        Document document = (Document)cmsContext.getDoc();
        if ("WikiBook".equals(document.getType()) || "WikiSection".equals(document.getType())) {
            return this.getWikiPlayer(cmsContext);
        }
        if ("FaqFolder".equals(document.getType()) || "Question".equals(document.getType())) {
            return this.getFaqPlayer(cmsContext);
        }
        if ("BlogPost".equals(document.getType())) {
            return this.getCMSMinimalPlayer(cmsContext);
        }
        if ("Forum".equals(document.getType())) {
            return this.getForumPlayer(cmsContext);
        }
        if ("Thread".equals(document.getType())) {
            return this.getForumThreadPlayer(cmsContext);
        }
        if ("Agenda".equals(document.getType())) {
            return this.getCalendarPlayer(cmsContext);
        }
        if ("VEVENT".equals(document.getType())) {
            return this.getEventPlayer(cmsContext);
        }
        return super.getCMSPlayer(cmsContext);
    }

    private CMSHandlerProperties getWikiPlayer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.uri", doc.getPath());
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("osivia.ajaxLink", "1");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("osivia-services-wiki-wikiPortletInstance");
        return linkProps;
    }

    private CMSHandlerProperties getFaqPlayer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.uri", doc.getPath());
        windowProperties.put("osivia.ajaxLink", "1");
        windowProperties.put("osivia.hideDecorators", "1");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-faq-portletInstance");
        return linkProps;
    }

    private CMSHandlerProperties getForumPlayer(CMSServiceCtx ctx) throws CMSException {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", this.createForumPlayerRequest(ctx));
        windowProperties.put("osivia.cms.style", STYLE_FORUM);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.ajaxLink", "1");
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    private String createForumPlayerRequest(CMSServiceCtx cmsContext) throws CMSException {
        Document document = (Document)cmsContext.getDoc();
        CMSPublicationInfos pubInfos = this.getCmsService().getPublicationInfos(cmsContext, document.getPath());
        StringBuilder request = new StringBuilder();
        request.append("ecm:parentId = '").append(pubInfos.getLiveId()).append("' ");
        request.append("AND ecm:primaryType = 'Thread' ");
        request.append("ORDER BY dc:modified DESC ");
        return request.toString();
    }

    private CMSHandlerProperties getForumThreadPlayer(CMSServiceCtx cmsContext) {
        Document document = (Document)cmsContext.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.uri", document.getPath());
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("osivia.ajaxLink", "1");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("osivia-services-forum-portletInstance");
        return linkProps;
    }

    private CMSHandlerProperties getCalendarPlayer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.uri", doc.getPath());
        windowProperties.put("osivia.title", doc.getTitle());
        windowProperties.put("osivia.hideTitle", "1");
        windowProperties.put("osivia.ajaxLink", "1");
        windowProperties.put("osivia.cms.hideMetaDatas", "1");
        windowProperties.put("osivia.calendar.cmsPath", "${contentPath}");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("osivia-services-calendar-instance");
        return linkProps;
    }

    private CMSHandlerProperties getEventPlayer(CMSServiceCtx ctx) {
        Document document = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.uri", document.getPath());
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewDocumentPortletInstance");
        return linkProps;
    }

    private CMSHandlerProperties getCMSMinimalPlayer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.uri", doc.getPath());
        windowProperties.put("osivia.hideTitle", "1");
        windowProperties.put("osivia.ajaxLink", "1");
        windowProperties.put("osivia.cms.hideMetaDatas", "1");
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewDocumentPortletInstance");
        return linkProps;
    }

    public Map<String, CMSItemType> getCMSItemTypes() {
        if (this.customCMSItemTypes == null) {
            this.customCMSItemTypes = new LinkedHashMap();
            this.customCMSItemTypes.putAll(super.getCMSItemTypes());
            List customizedTypes = this.getCustomizedCMSItemTypes();
            for (CMSItemType customizedType : customizedTypes) {
                this.customCMSItemTypes.put(customizedType.getName(), customizedType);
            }
        }
        return this.customCMSItemTypes;
    }

    private List<CMSItemType> getCustomizedCMSItemTypes() {
        ArrayList<CMSItemType> customizedTypes = new ArrayList<CMSItemType>();
        customizedTypes.add(new CMSItemType("BlogSite", true, true, true, false, true, true, Arrays.asList("BlogPost", "ContextualLink"), null, "glyphicons glyphicons-blog", true));
        customizedTypes.add(new CMSItemType("BlogPost", false, false, false, false, true, true, new ArrayList(0), null, "glyphicons glyphicons-blog"));
        customizedTypes.add(new CMSItemType("FaqFolder", true, false, false, false, false, true, Arrays.asList("Question"), null, "glyphicons glyphicons-circle-question-mark"));
        customizedTypes.add(new CMSItemType("Question", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-circle-question-mark"));
        customizedTypes.add(new CMSItemType("Forum", true, true, false, false, true, true, Arrays.asList("Thread"), null, "glyphicons glyphicons-conversation"));
        customizedTypes.add(new CMSItemType("Thread", false, false, false, false, true, true, new ArrayList(0), null, "glyphicons glyphicons-chat"));
        customizedTypes.add(new CMSItemType("Agenda", true, true, false, false, true, true, Arrays.asList("VEVENT"), null, "glyphicons glyphicons-calendar"));
        customizedTypes.add(new CMSItemType("VEVENT", false, false, false, false, true, true, new ArrayList(0), null, "glyphicons glyphicons-calendar"));
        customizedTypes.add(new CMSItemType("WikiBook", true, true, true, true, true, true, Arrays.asList("WikiSection"), null, "book"));
        customizedTypes.add(new CMSItemType("WikiSection", true, true, true, true, true, true, Arrays.asList("WikiSection"), null, "book"));
        return customizedTypes;
    }
}

