/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.FragmentType;
import fr.toutatice.portail.cms.nuxeo.api.domain.ITemplateModule;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCommentsService;
import fr.toutatice.portail.cms.nuxeo.api.services.INuxeoCustomizer;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoConnectionProperties;
import fr.toutatice.portail.cms.nuxeo.portlets.comments.CommentsFormatter;
import fr.toutatice.portail.cms.nuxeo.portlets.comments.NuxeoCommentsServiceImpl;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.BrowserAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.CMSItemAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.DefaultPlayer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.EditableWindowAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.IPlayer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.MenuBarFormater;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.NavigationItemAdapter;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.UserPagesLoader;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationQueryCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WysiwygParser;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.XSLFunctions;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.DocumentPictureFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.LinkFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.LinksFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.NavigationPictureFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.PropertyFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.SitePictureFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.SliderTemplateModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.SpaceMenubarFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.SummaryFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.fragment.ZoomFragmentModule;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import fr.toutatice.portail.cms.nuxeo.portlets.service.DocumentPublishSpaceNavigationCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.LockCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.SubscribeCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.SynchronizeCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.UnlockCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.UnsubscribeCommand;
import fr.toutatice.portail.cms.nuxeo.service.commands.UnsynchronizeCommand;
import java.io.ByteArrayOutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.portlet.PortletContext;
import javax.portlet.PortletResponse;
import javax.portlet.ResourceURL;
import javax.security.auth.Subject;
import javax.security.jacc.PolicyContext;
import javax.servlet.http.HttpSessionEvent;
import javax.xml.transform.Transformer;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.Portal;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.PortalObjectPath;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.server.ServerInvocation;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.IDirectoryService;
import org.osivia.portal.api.ecm.EcmCommand;
import org.osivia.portal.api.ecm.EcmCommonCommands;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.menubar.MenubarItem;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.urls.IPortalUrlFactory;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.core.cms.BinaryDelegation;
import org.osivia.portal.core.cms.BinaryDescription;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSHandlerProperties;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSItemType;
import org.osivia.portal.core.cms.CMSPage;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.page.PageProperties;
import org.osivia.portal.core.web.IWebIdService;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class DefaultCMSCustomizer
implements INuxeoCustomizer {
    protected static final Log LOGGER = LogFactory.getLog(DefaultCMSCustomizer.class);
    public static final String LIST_TEMPLATE_MINI = "mini";
    public static final String LIST_TEMPLATE_NORMAL = "normal";
    public static final String LIST_TEMPLATE_DETAILED = "detailed";
    public static final String LIST_TEMPLATE_EDITORIAL = "editorial";
    public static final String LIST_TEMPLATE_CONTEXTUAL_LINKS = "contextual-links";
    public static final String LIST_TEMPLATE_SLIDER = "slider";
    public static final String DEFAULT_SCHEMAS = "dublincore, common, toutatice, file";
    public static final String SLIDER_SCHEMAS = "dublincore, toutatice, picture, annonce";
    public static final String TEMPLATE_DOWNLOAD = "download";
    private static final String AVATAR_SERVLET = "/toutatice-portail-cms-nuxeo/avatar?username=";
    private static final String BINARY_SERVLET = "/toutatice-portail-cms-nuxeo/binary";
    private final PortletContext portletCtx;
    private final IPortalUrlFactory portalUrlFactory;
    private final IBundleFactory bundleFactory;
    private UserPagesLoader userPagesLoader;
    private MenuBarFormater menuBarFormater;
    private NavigationItemAdapter navigationItemAdapter;
    private CMSItemAdapter cmsItemAdapter;
    private NuxeoConnectionProperties nuxeoConnection;
    private XMLReader parser;
    private EditableWindowAdapter editableWindowAdapter;
    private INuxeoCommentsService commentsService;
    private ClassLoader cl;
    private Map<String, CMSItemType> cmsItemTypes;
    private final Map<String, IPlayer> players;
    private CMSService cmsService;
    private IWebIdService webIdService;
    private IDirectoryService directoryService;
    private INotificationsService notificationsService;
    private IInternationalizationService internationalizationService;
    private Map<String, String> avatarMap = new ConcurrentHashMap();
    private Map<String, String> binaryMap = new ConcurrentHashMap();
    public static Map<String, Map<String, BinaryDelegation>> delegations = new ConcurrentHashMap();

    public DefaultCMSCustomizer(PortletContext ctx) {
        this.portletCtx = ctx;
        this.portalUrlFactory = (IPortalUrlFactory)this.portletCtx.getAttribute("UrlService");
        IInternationalizationService internationalizationService = (IInternationalizationService)this.portletCtx.getAttribute("InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.players = new HashMap();
        this.players.put("defaultPlayer", new DefaultPlayer(this));
        try {
            this.cl = Thread.currentThread().getContextClassLoader();
            this.parser = WysiwygParser.getInstance().getParser();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public IWebIdService getWebIdService() {
        if (this.webIdService == null) {
            this.webIdService = (IWebIdService)this.portletCtx.getAttribute("webIdService");
        }
        return this.webIdService;
    }

    public NuxeoConnectionProperties getNuxeoConnectionProps() {
        if (this.nuxeoConnection == null) {
            this.nuxeoConnection = new NuxeoConnectionProperties();
        }
        return this.nuxeoConnection;
    }

    public UserPagesLoader getUserPagesLoader() {
        if (this.userPagesLoader == null) {
            this.userPagesLoader = new UserPagesLoader(this.portletCtx, this, this.cmsService);
        }
        return this.userPagesLoader;
    }

    public MenuBarFormater getMenuBarFormater() {
        if (this.menuBarFormater == null) {
            this.menuBarFormater = new MenuBarFormater(this.portletCtx, this, this.cmsService);
        }
        return this.menuBarFormater;
    }

    public NavigationItemAdapter getNavigationItemAdapter() {
        if (this.navigationItemAdapter == null) {
            this.navigationItemAdapter = new NavigationItemAdapter(this.portletCtx, this, this.cmsService);
        }
        return this.navigationItemAdapter;
    }

    public CMSItemAdapter getCMSItemAdapter() {
        if (this.cmsItemAdapter == null) {
            this.cmsItemAdapter = new CMSItemAdapter(this.portletCtx, this, this.cmsService);
        }
        return this.cmsItemAdapter;
    }

    public EditableWindowAdapter getEditableWindowAdapter() {
        if (this.editableWindowAdapter == null) {
            this.editableWindowAdapter = new EditableWindowAdapter();
        }
        return this.editableWindowAdapter;
    }

    public BrowserAdapter getBrowserAdapter() {
        return BrowserAdapter.getInstance((CMSService)this.cmsService);
    }

    public INuxeoCommentsService getNuxeoCommentsService() {
        if (this.commentsService == null) {
            this.commentsService = new NuxeoCommentsServiceImpl(this.cmsService, this.directoryService);
        }
        return this.commentsService;
    }

    public List<ListTemplate> getListTemplates(Locale locale) {
        ArrayList<ListTemplate> templates = new ArrayList<ListTemplate>();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        templates.add(new ListTemplate(LIST_TEMPLATE_MINI, bundle.getString("LIST_TEMPLATE_MINI"), DEFAULT_SCHEMAS));
        templates.add(new ListTemplate(LIST_TEMPLATE_NORMAL, bundle.getString("LIST_TEMPLATE_NORMAL"), DEFAULT_SCHEMAS));
        templates.add(new ListTemplate(LIST_TEMPLATE_DETAILED, bundle.getString("LIST_TEMPLATE_DETAILED"), DEFAULT_SCHEMAS));
        templates.add(new ListTemplate(LIST_TEMPLATE_EDITORIAL, bundle.getString("LIST_TEMPLATE_EDITORIAL"), DEFAULT_SCHEMAS));
        templates.add(new ListTemplate(LIST_TEMPLATE_CONTEXTUAL_LINKS, bundle.getString("LIST_TEMPLATE_CONTEXTUAL_LINKS"), DEFAULT_SCHEMAS));
        ListTemplate slider = new ListTemplate(LIST_TEMPLATE_SLIDER, bundle.getString("LIST_TEMPLATE_SLIDER"), SLIDER_SCHEMAS);
        slider.setModule((ITemplateModule)new SliderTemplateModule());
        templates.add(slider);
        return templates;
    }

    public List<FragmentType> getFragmentTypes(Locale locale) {
        ArrayList<FragmentType> fragmentTypes = new ArrayList<FragmentType>();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        fragmentTypes.add(new FragmentType("text_property", bundle.getString("FRAGMENT_TYPE_TEXT"), PropertyFragmentModule.getInstance((boolean)false)));
        fragmentTypes.add(new FragmentType("html_property", bundle.getString("FRAGMENT_TYPE_HTML"), PropertyFragmentModule.getInstance((boolean)true)));
        fragmentTypes.add(new FragmentType("zoom_property", bundle.getString("FRAGMENT_TYPE_ZOOM"), ZoomFragmentModule.getInstance()));
        fragmentTypes.add(new FragmentType("links_property", bundle.getString("FRAGMENT_TYPE_LINKS"), LinksFragmentModule.getInstance()));
        fragmentTypes.add(new FragmentType("navigation_picture", bundle.getString("FRAGMENT_TYPE_NAVIGATION_PICTURE"), NavigationPictureFragmentModule.getInstance()));
        fragmentTypes.add(new FragmentType("document_picture", bundle.getString("FRAGMENT_TYPE_DOCUMENT_PICTURE"), DocumentPictureFragmentModule.getInstance()));
        fragmentTypes.add(new FragmentType("doc_link", bundle.getString("FRAGMENT_TYPE_LINK"), LinkFragmentModule.getInstance()));
        fragmentTypes.add(new FragmentType("space_menubar", bundle.getString("FRAGMENT_TYPE_MENUBAR"), SpaceMenubarFragmentModule.getInstance()));
        fragmentTypes.add(new FragmentType("site_picture", bundle.getString("FRAGMENT_TYPE_SITE_PICTURE"), SitePictureFragmentModule.getInstance()));
        fragmentTypes.add(new FragmentType("fgts_summary", bundle.getString("FRAGMENT_TYPE_SUMMARY"), SummaryFragmentModule.getInstance()));
        return fragmentTypes;
    }

    public SortedMap<String, String> getMenuTemplates(Locale locale) {
        TreeMap<String, String> templates = new TreeMap<String, String>();
        Bundle bundle = this.bundleFactory.getBundle(locale);
        templates.put("", bundle.getString("MENU_TEMPLATE_DEFAULT"));
        templates.put("horizontal", bundle.getString("MENU_TEMPLATE_HORIZONTAL"));
        templates.put("footer", bundle.getString("MENU_TEMPLATE_FOOTER"));
        templates.put("fancytree-lazy", bundle.getString("MENU_TEMPLATE_FANCYTREE_LAZY"));
        templates.put("fancytree-filter", bundle.getString("MENU_TEMPLATE_FANCYTREE_FILTER"));
        return templates;
    }

    public static String getSearchSchema() {
        return "dublincore,common,file,toutatice";
    }

    public CMSHandlerProperties getCMSDefaultPlayer(CMSServiceCtx ctx) throws Exception {
        Document doc = (Document)ctx.getDoc();
        return ((IPlayer)this.players.get("defaultPlayer")).play(ctx, doc);
    }

    protected String createFolderRequest(CMSServiceCtx ctx, boolean ordered) throws CMSException {
        String nuxeoRequest = null;
        Document doc = (Document)ctx.getDoc();
        CMSPublicationInfos pubInfos = this.cmsService.getPublicationInfos(ctx, doc.getPath());
        List navItems = null;
        if (ctx.getContextualizationBasePath() != null) {
            navItems = this.cmsService.getPortalNavigationSubitems(ctx, ctx.getContextualizationBasePath(), DocumentPublishSpaceNavigationCommand.computeNavPath((String)doc.getPath()));
        }
        if (navItems != null) {
            nuxeoRequest = "ecm:parentId = '" + pubInfos.getLiveId() + "' AND ecm:mixinType != 'Folderish'";
            nuxeoRequest = ordered ? nuxeoRequest + " order by ecm:pos" : nuxeoRequest + " order by dc:modified desc";
        } else {
            nuxeoRequest = "ecm:path STARTSWITH '" + DocumentPublishSpaceNavigationCommand.computeNavPath((String)doc.getPath()) + "' AND ecm:mixinType != 'Folderish' ";
            nuxeoRequest = ordered ? nuxeoRequest + " order by ecm:pos" : nuxeoRequest + " order by dc:modified desc";
        }
        return nuxeoRequest;
    }

    public CMSHandlerProperties getCMSAnnonceFolderPlayer(CMSServiceCtx ctx) throws CMSException {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", this.createFolderRequest(ctx, false));
        windowProperties.put("osivia.cms.style", LIST_TEMPLATE_EDITORIAL);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.document.metadata", String.valueOf(false));
        windowProperties.put("osivia.title", doc.getTitle());
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public CMSHandlerProperties getCMSOrderedFolderPlayer(CMSServiceCtx ctx) throws CMSException {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", this.createFolderRequest(ctx, true));
        windowProperties.put("osivia.cms.style", LIST_TEMPLATE_EDITORIAL);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.document.metadata", String.valueOf(false));
        windowProperties.put("osivia.title", "Dossier " + doc.getTitle());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public CMSHandlerProperties getCMSUrlContainerPlayer(CMSServiceCtx ctx) throws CMSException {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", this.createFolderRequest(ctx, true));
        windowProperties.put("osivia.cms.style", LIST_TEMPLATE_CONTEXTUAL_LINKS);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", ctx.getHideMetaDatas());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public CMSHandlerProperties getCMSFileBrowser(CMSServiceCtx cmsContext) {
        Document document = (Document)cmsContext.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.scope", cmsContext.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", cmsContext.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", cmsContext.getHideMetaDatas());
        windowProperties.put("osivia.cms.uri", document.getPath());
        windowProperties.put("osivia.cms.publishPathAlreadyConverted", "1");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("osivia.ajaxLink", "1");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-fileBrowserPortletInstance");
        return linkProps;
    }

    public CMSHandlerProperties getCMSFolderPlayer(CMSServiceCtx ctx) throws CMSException {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", this.createFolderRequest(ctx, false));
        windowProperties.put("osivia.cms.style", LIST_TEMPLATE_EDITORIAL);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", ctx.getHideMetaDatas());
        windowProperties.put("osivia.title", "Dossier " + doc.getTitle());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public CMSHandlerProperties getCMSSectionPlayer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", "ecm:path STARTSWITH '" + doc.getPath() + "' AND ecm:mixinType != 'Folderish' ORDER BY dc:modified DESC");
        windowProperties.put("osivia.cms.style", LIST_TEMPLATE_EDITORIAL);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", ctx.getHideMetaDatas());
        windowProperties.put("osivia.title", "Dossier " + doc.getTitle());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public CMSHandlerProperties getCMSVirtualPagePlayer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.nuxeoRequest", doc.getString("ttc:queryPart"));
        windowProperties.put("osivia.cms.style", LIST_TEMPLATE_EDITORIAL);
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.hideMetaDatas", ctx.getHideMetaDatas());
        windowProperties.put("osivia.title", "Dossier " + doc.getTitle());
        windowProperties.put("osivia.cms.pageSizeMax", "10");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance("toutatice-portail-cms-nuxeo-viewListPortletInstance");
        return linkProps;
    }

    public CMSHandlerProperties createPortletLink(CMSServiceCtx ctx, String portletInstance, String uid) {
        HashMap<String, String> windowProperties = new HashMap<String, String>();
        windowProperties.put("osivia.cms.scope", ctx.getScope());
        windowProperties.put("osivia.cms.displayLiveVersion", ctx.getDisplayLiveVersion());
        windowProperties.put("osivia.cms.hideMetaDatas", ctx.getHideMetaDatas());
        windowProperties.put("osivia.cms.uri", uid);
        windowProperties.put("osivia.cms.publishPathAlreadyConverted", "1");
        windowProperties.put("osivia.hideDecorators", "1");
        windowProperties.put("theme.dyna.partial_refresh_enabled", "false");
        CMSHandlerProperties linkProps = new CMSHandlerProperties();
        linkProps.setWindowProperties(windowProperties);
        linkProps.setPortletInstance(portletInstance);
        return linkProps;
    }

    public CMSHandlerProperties getCMSPlayer(CMSServiceCtx ctx) throws Exception {
        Document doc = (Document)ctx.getDoc();
        if ("UserWorkspace".equals(doc.getType())) {
            ctx.setDisplayLiveVersion("1");
            return this.getCMSFileBrowser(ctx);
        }
        if ("DocumentUrlContainer".equals(doc.getType())) {
            return this.getCMSUrlContainerPlayer(ctx);
        }
        if ("AnnonceFolder".equals(doc.getType())) {
            return this.getCMSAnnonceFolderPlayer(ctx);
        }
        if ("Folder".equals(doc.getType()) || "OrderedFolder".equals(doc.getType()) || "Section".equals(doc.getType())) {
            CMSItem spaceConfig;
            String spaceType;
            if (ctx.getContextualizationBasePath() != null && !doc.getTitle().startsWith("test-list") && ("Workspace".equals(spaceType = ((Document)(spaceConfig = this.cmsService.getSpaceConfig(ctx, ctx.getContextualizationBasePath())).getNativeItem()).getType()) || "UserWorkspace".equals(spaceType))) {
                ctx.setDisplayLiveVersion("1");
                CMSHandlerProperties props = this.getCMSFileBrowser(ctx);
                props.getWindowProperties().put("osivia.title", doc.getTitle());
                return props;
            }
            if ("Folder".equals(doc.getType())) {
                return this.getCMSFolderPlayer(ctx);
            }
            return this.getCMSOrderedFolderPlayer(ctx);
        }
        if ("PortalVirtualPage".equals(doc.getType())) {
            return this.getCMSVirtualPagePlayer(ctx);
        }
        String domainPath = WebConfigurationHelper.getDomainPath((CMSServiceCtx)ctx);
        if (domainPath != null) {
            WebConfigurationQueryCommand command = new WebConfigurationQueryCommand(domainPath, WebConfigurationQueryCommand.WebConfigurationType.CMS_PLAYER);
            Documents configs = null;
            try {
                configs = WebConfigurationHelper.executeWebConfigCmd((CMSServiceCtx)ctx, (CMSService)this.cmsService, (WebConfigurationQueryCommand)command);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (configs != null && configs.size() > 0) {
                for (Document config : configs) {
                    String documentType = config.getProperties().getString("wconf:code");
                    String playerInstance = config.getProperties().getString("wconf:code2");
                    if (!doc.getType().equals(documentType) || !this.players.containsKey(playerInstance)) continue;
                    HashMap<String, String> windowProperties = new HashMap<String, String>();
                    PropertyList list = config.getProperties().getList("wconf:options");
                    for (Object o : list.list()) {
                        if (!(o instanceof PropertyMap)) continue;
                        PropertyMap map = (PropertyMap)o;
                        windowProperties.put(map.get("propertyName").toString(), map.get("propertyDefaultValue").toString());
                    }
                    return ((IPlayer)this.players.get(playerInstance)).play(ctx, doc, windowProperties);
                }
            }
        }
        return ((IPlayer)this.players.get("defaultPlayer")).play(ctx, doc);
    }

    public String getDefaultExternalViewer(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        this.getNuxeoConnectionProps();
        String externalUrl = NuxeoConnectionProperties.getPublicBaseUri().toString() + "/nxdoc/default/" + doc.getId() + "/view_documents";
        return externalUrl;
    }

    public String createPortletDelegatedExternalLink(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        ResourceURL resourceURL = ctx.getResponse().createResourceURL();
        resourceURL.setResourceID(doc.getId());
        resourceURL.setParameter("type", "link");
        return resourceURL.toString();
    }

    public String createPortletDelegatedFileContentLink(CMSServiceCtx ctx) {
        Document doc = (Document)ctx.getDoc();
        ResourceURL resourceURL = ctx.getResponse().createResourceURL();
        resourceURL.setResourceID(doc.getId() + "/" + "file:content");
        resourceURL.setParameter("type", "file");
        resourceURL.setParameter("docPath", doc.getPath());
        resourceURL.setParameter("fieldName", "file:content");
        resourceURL.setCacheability("cacheLevelPage");
        return resourceURL.toString();
    }

    public String getNuxeoNativeViewerUrl(CMSServiceCtx ctx) {
        if ("file-browser-menu-workspace".equals(ctx.getDisplayContext())) {
            return this.getDefaultExternalViewer(ctx);
        }
        return null;
    }

    public Link createCustomLink(CMSServiceCtx ctx) throws Exception {
        Document doc = (Document)ctx.getDoc();
        String url = null;
        boolean externalLink = false;
        boolean downloadable = false;
        if (!"detailedView".equals(ctx.getDisplayContext())) {
            PropertyMap attachedFileProperties;
            if (("File".equals(doc.getType()) || "Audio".equals(doc.getType()) || "Video".equals(doc.getType())) && TEMPLATE_DOWNLOAD.equals(ctx.getDisplayContext()) && (attachedFileProperties = doc.getProperties().getMap("file:content")) != null && !attachedFileProperties.isEmpty()) {
                NuxeoController nuxeoCtl = new NuxeoController(ctx.getRequest(), (PortletResponse)ctx.getResponse(), ctx.getPortletCtx());
                nuxeoCtl.setCurrentDoc(doc);
                url = nuxeoCtl.createFileLink(doc, "file:content");
                downloadable = true;
            }
            if ("ContextualLink".equals(doc.getType()) && !"document".equals(ctx.getDisplayContext())) {
                url = this.createPortletDelegatedExternalLink(ctx);
                externalLink = true;
            }
            if (url == null) {
                url = this.getNuxeoNativeViewerUrl(ctx);
                externalLink = true;
            }
        }
        if (url != null) {
            Link link = new Link(url, externalLink);
            link.setDownloadable(downloadable);
            return link;
        }
        return null;
    }

    public void formatContentMenuBar(CMSServiceCtx ctx) throws Exception {
        this.getMenuBarFormater().formatContentMenuBar(ctx);
        List menuBar = (List)ctx.getRequest().getAttribute("osivia.menuBar");
        this.adaptContentMenuBar(ctx, menuBar);
    }

    protected void adaptContentMenuBar(CMSServiceCtx ctx, List<MenubarItem> menuBar) {
    }

    public List<CMSPage> computeUserPreloadedPages(CMSServiceCtx cmsCtx) throws Exception {
        return this.getUserPagesLoader().computeUserPreloadedPages(cmsCtx);
    }

    public Map<String, String> parseCMSURL(CMSServiceCtx cmsCtx, String requestPath, Map<String, String> requestParameters) throws Exception {
        return null;
    }

    public Map<String, String> getDocumentConfiguration(CMSServiceCtx ctx, Document doc) throws Exception {
        return this.getCMSItemAdapter().adaptDocument(ctx, doc);
    }

    public String addPublicationFilter(CMSServiceCtx ctx, String nuxeoRequest, String requestFilteringPolicy) throws Exception {
        String requestFilter = "";
        requestFilter = "1".equals(ctx.getDisplayLiveVersion()) ? "ecm:mixinType != 'HiddenInNavigation' AND ecm:isProxy = 0  AND ecm:currentLifeCycleState <> 'deleted'  AND ecm:isCheckedInVersion = 0 " : "ecm:isProxy = 1 AND ecm:mixinType != 'HiddenInNavigation'  AND ecm:currentLifeCycleState <> 'deleted' ";
        String policyFilter = null;
        ServerInvocation invocation = ctx.getServerInvocation();
        String portalName = null;
        if (invocation != null) {
            portalName = (String)PageProperties.getProperties().getPagePropertiesMap().get("portalName");
        }
        if (portalName != null) {
            String extraFilter;
            PortalObjectContainer portalObjectContainer = (PortalObjectContainer)invocation.getAttribute(Scope.REQUEST_SCOPE, (Object)"osivia.portalObjectContainer");
            PortalObject po = portalObjectContainer.getObject(PortalObjectId.parse((String)"", (String)("/" + portalName), (PortalObjectPath.Format)PortalObjectPath.CANONICAL_FORMAT));
            if (requestFilteringPolicy != null) {
                policyFilter = requestFilteringPolicy;
            } else {
                String sitePolicy = po.getProperty("osivia.cms.requestFilteringPolicy");
                if (sitePolicy != null) {
                    if ("local".equals(sitePolicy)) {
                        policyFilter = "local";
                    }
                } else {
                    String portalType = po.getProperty("osivia.portal.portalType");
                    if ("space".equals(portalType)) {
                        policyFilter = "local";
                    }
                }
            }
            if ("local".equals(policyFilter)) {
                String pathFilter = "";
                for (PortalObject child : ((Portal)po).getChildren(4)) {
                    String cmsPath = child.getDeclaredProperty("osivia.cms.basePath");
                    if (cmsPath == null || cmsPath.length() <= 0) continue;
                    if (pathFilter.length() > 0) {
                        pathFilter = pathFilter + " OR ";
                    }
                    pathFilter = pathFilter + "ecm:path STARTSWITH '" + cmsPath + "'";
                }
                if (pathFilter.length() > 0) {
                    requestFilter = requestFilter + " AND " + "(" + pathFilter + ")";
                }
            }
            if ((extraFilter = this.getExtraRequestFilter(ctx, requestFilteringPolicy)) != null) {
                requestFilter = requestFilter + " OR " + "(" + extraFilter + ")";
            }
        }
        String beforeOrderBy = "";
        String orderBy = "";
        String editedNuxeoRequest = nuxeoRequest;
        try {
            Pattern ressourceExp = Pattern.compile("(.*)ORDER([ ]*)BY(.*)");
            Matcher m = ressourceExp.matcher(editedNuxeoRequest.toUpperCase());
            m.matches();
            if (m.groupCount() == 3) {
                beforeOrderBy = editedNuxeoRequest.substring(0, m.group(1).length());
                orderBy = editedNuxeoRequest.substring(m.group(1).length());
            }
        }
        catch (IllegalStateException e) {
            beforeOrderBy = editedNuxeoRequest;
        }
        String finalRequest = beforeOrderBy;
        if (finalRequest.length() > 0) {
            finalRequest = finalRequest + " AND ";
        }
        finalRequest = finalRequest + "(" + requestFilter + ") ";
        editedNuxeoRequest = finalRequest = finalRequest + " " + orderBy;
        return editedNuxeoRequest;
    }

    public String getExtraRequestFilter(CMSServiceCtx ctx, String requestFilteringPolicy) throws Exception {
        String extraRequetFilter = null;
        String domainPath = WebConfigurationHelper.getDomainPath((CMSServiceCtx)ctx);
        if (domainPath != null) {
            WebConfigurationQueryCommand command = new WebConfigurationQueryCommand(domainPath, WebConfigurationQueryCommand.WebConfigurationType.EXTRA_REQUEST_FILTER);
            Documents configs = null;
            configs = WebConfigurationHelper.executeWebConfigCmd((CMSServiceCtx)ctx, (CMSService)this.cmsService, (WebConfigurationQueryCommand)command);
            if (configs.size() > 0) {
                extraRequetFilter = "";
                int i = 0;
                for (Document config : configs) {
                    String nxqlCode = config.getProperties().getString("wconf:code");
                    if (nxqlCode == null) continue;
                    if (i > 0) {
                        extraRequetFilter = extraRequetFilter.concat("OR");
                    }
                    extraRequetFilter = extraRequetFilter.concat(" ").concat(nxqlCode);
                    ++i;
                }
            }
        }
        return extraRequetFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String transformHTMLContent(CMSServiceCtx ctx, String htmlContent) throws Exception {
        ClassLoader originalCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.cl);
        try {
            Transformer transformer = WysiwygParser.getInstance().getTemplate().newTransformer();
            transformer.setParameter("bridge", new XSLFunctions((INuxeoCustomizer)this, ctx));
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            XMLReader parser = WysiwygParser.getInstance().getParser();
            transformer.transform(new SAXSource(parser, new InputSource(new StringReader(htmlContent))), new StreamResult(output));
            String string = ((Object)output).toString();
            return string;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalCL);
        }
    }

    public String transformLink(CMSServiceCtx ctx, String link) {
        XSLFunctions xslFunctions = new XSLFunctions((INuxeoCustomizer)this, ctx);
        return xslFunctions.link(NuxeoConnectionProperties.getPublicDomainUri().toString() + link);
    }

    public Link getLinkFromNuxeoURL(CMSServiceCtx cmsContext, String url) {
        Link link;
        PortalControllerContext portalControllerContext = new PortalControllerContext((Object)cmsContext.getControllerContext());
        if (StringUtils.startsWith((String)url, (String)"/nuxeo/")) {
            Page page;
            Window window;
            String nuxeoURL = StringUtils.substringBefore((String)url, (String)"#");
            String anchor = StringUtils.substringAfter((String)url, (String)"#");
            String cmsPath = this.transformNuxeoURL(cmsContext, nuxeoURL);
            String currentPagePath = null;
            if (cmsContext.getRequest() != null && (window = (Window)cmsContext.getRequest().getAttribute("osivia.window")) != null && (page = window.getPage()) != null) {
                currentPagePath = page.getId().toString(PortalObjectPath.CANONICAL_FORMAT);
            }
            String portalURL = this.portalUrlFactory.getCMSUrl(portalControllerContext, currentPagePath, cmsPath, null, null, null, null, null, null, null);
            if (StringUtils.isNotBlank((String)anchor)) {
                portalURL = portalURL + "#" + anchor;
            }
            link = new Link(portalURL, false);
        } else if (StringUtils.isBlank((String)url)) {
            link = new Link("#", false);
        } else {
            boolean external;
            try {
                URL urlObject = new URL(url);
                String serverName = cmsContext.getRequest().getServerName();
                external = !StringUtils.equals((String)urlObject.getHost(), (String)serverName);
            }
            catch (Exception e) {
                external = false;
            }
            link = new Link(url, external);
        }
        return link;
    }

    private String transformNuxeoURL(CMSServiceCtx cmsContext, String url) {
        String cmsPath = null;
        if (StringUtils.startsWith((String)url, (String)"/nuxeo/web/")) {
            String webPath = StringUtils.removeStart((String)url, (String)"/nuxeo/web/");
            String[] splittedWebPath = StringUtils.split((String)webPath, (String)"/");
            if (splittedWebPath.length > 1) {
                String domainId = splittedWebPath[0];
                String webId = splittedWebPath[splittedWebPath.length - 1];
                String serviceWebId = this.getWebIdService().domainAndIdToFetchInfoService(domainId, webId);
                String path = null;
                try {
                    CMSPublicationInfos pubInfos = this.getCmsService().getPublicationInfos(cmsContext, serviceWebId);
                    path = pubInfos.getDocumentPath();
                }
                catch (CMSException e) {
                    // empty catch block
                }
                CMSItem cmsItem = new CMSItem(path, domainId, webId, null, null);
                cmsPath = this.getWebIdService().itemToPageUrl(cmsContext, cmsItem);
            }
        } else if (StringUtils.startsWith((String)url, (String)"/nuxeo/nxpath/")) {
            cmsPath = StringUtils.removeStart((String)url, (String)"/nuxeo/nxpath/");
            cmsPath = "/" + StringUtils.substringAfter((String)cmsPath, (String)"/");
        }
        if (cmsPath == null) {
            LOGGER.warn((Object)("Invalid Nuxeo URL: '" + url + "'."));
        }
        return cmsPath;
    }

    public Map<String, CMSItemType> getCMSItemTypes() {
        if (this.cmsItemTypes == null) {
            List defaultTypes = this.getDefaultCMSItemTypes();
            this.cmsItemTypes = new LinkedHashMap(defaultTypes.size());
            for (CMSItemType defaultType : defaultTypes) {
                this.cmsItemTypes.put(defaultType.getName(), defaultType);
            }
        }
        return this.cmsItemTypes;
    }

    private List<CMSItemType> getDefaultCMSItemTypes() {
        ArrayList<CMSItemType> defaultTypes = new ArrayList<CMSItemType>();
        defaultTypes.add(new CMSItemType("Workspace", true, false, false, true, false, false, Arrays.asList("Folder", "DocumentUrlContainer", "AnnonceFolder", "PictureBook"), "/default/templates/workspace", "glyphicons glyphicons-wallet", true));
        defaultTypes.add(new CMSItemType("PortalSite", true, false, false, true, true, true, Arrays.asList("File", "Audio", "Video", "Annonce", "PortalPage", "Picture", "ContextualLink"), null, "glyphicons glyphicons-global", true));
        defaultTypes.add(new CMSItemType("PortalPage", true, true, true, true, true, true, Arrays.asList("File", "Audio", "Video", "Annonce", "PortalPage", "Picture", "ContextualLink"), null, "glyphicons glyphicons-more-items"));
        defaultTypes.add(new CMSItemType("Folder", true, true, true, false, false, true, Arrays.asList("File", "Audio", "Video", "Folder", "Note", "Picture", "ContextualLink"), null, "glyphicons glyphicons-folder-closed"));
        defaultTypes.add(new CMSItemType("OrderedFolder", true, true, true, true, false, true, Arrays.asList("File", "Audio", "Video", "Folder", "Note", "Picture", "ContextualLink"), null, "glyphicons glyphicons-folder-closed"));
        defaultTypes.add(new CMSItemType("File", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-file"));
        defaultTypes.add(new CMSItemType("Audio", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-headphones"));
        defaultTypes.add(new CMSItemType("Video", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-film"));
        defaultTypes.add(new CMSItemType("Note", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-notes-2"));
        defaultTypes.add(new CMSItemType("Annonce", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-newspaper"));
        defaultTypes.add(new CMSItemType("AnnonceFolder", true, true, false, false, false, true, Arrays.asList("Annonce"), null, "glyphicons glyphicons-newspaper"));
        defaultTypes.add(new CMSItemType("ContextualLink", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-link"));
        defaultTypes.add(new CMSItemType("DocumentUrlContainer", true, true, false, false, false, true, Arrays.asList("ContextualLink"), null, "glyphicons glyphicons-bookmark"));
        defaultTypes.add(new CMSItemType("PictureBook", true, false, true, true, false, true, Arrays.asList("Picture", "PictureBook"), null, "glyphicons glyphicons-picture"));
        defaultTypes.add(new CMSItemType("Picture", false, false, false, false, false, true, new ArrayList(0), null, "glyphicons glyphicons-picture"));
        return defaultTypes;
    }

    public String getCommentsHTMLContent(CMSServiceCtx cmsContext, Document document) throws CMSException {
        List comments = this.getNuxeoCommentsService().getDocumentComments(cmsContext, document);
        CommentsFormatter formatter = new CommentsFormatter(comments);
        Locale locale = cmsContext.getRequest().getLocale();
        return formatter.generateHTMLContent(locale);
    }

    public CMSService getCmsService() {
        return this.cmsService;
    }

    public void setCmsService(CMSService cmsService) {
        this.cmsService = cmsService;
    }

    public IDirectoryService getDirectoryService() {
        return this.directoryService;
    }

    public void setDirectoryService(IDirectoryService directoryService) {
        this.directoryService = directoryService;
    }

    public INotificationsService getNotificationsService() {
        return this.notificationsService;
    }

    public void setNotificationsService(INotificationsService notificationsService) {
        this.notificationsService = notificationsService;
    }

    public IInternationalizationService getInternationalizationService() {
        return this.internationalizationService;
    }

    public void setInternationalizationService(IInternationalizationService internationalizationService) {
        this.internationalizationService = internationalizationService;
    }

    public PortletContext getPortletCtx() {
        return this.portletCtx;
    }

    public void setNavigationItemAdapter(NavigationItemAdapter navigationItemAdapter) {
        this.navigationItemAdapter = navigationItemAdapter;
    }

    public XMLReader getParser() {
        return this.parser;
    }

    public void setParser(XMLReader parser) {
        this.parser = parser;
    }

    public String getContentWebIdPath(CMSServiceCtx cmsCtx) {
        Document doc = (Document)cmsCtx.getDoc();
        String webId = doc.getString("ttc:webid");
        String domainId = doc.getString("ttc:domainID");
        String permLinkPath = ((Document)cmsCtx.getDoc()).getPath();
        if (StringUtils.isNotEmpty((String)webId) && StringUtils.isNotEmpty((String)domainId)) {
            String explicitUrl = doc.getString("ttc:explicitUrl");
            String extension = doc.getString("ttc:extensionUrl");
            HashMap<String, String> properties = new HashMap<String, String>();
            if (explicitUrl != null) {
                properties.put("explicitUrl", explicitUrl);
            }
            if (extension != null) {
                properties.put("extensionUrl", extension);
            }
            CMSItem cmsItem = new CMSItem(doc.getPath(), domainId, webId, properties, (Object)doc);
            permLinkPath = this.getWebIdService().itemToPageUrl(cmsCtx, cmsItem);
        }
        return permLinkPath;
    }

    public Link getUserAvatar(CMSServiceCtx cmsCtx, String username) throws CMSException {
        String src = "";
        try {
            String avatarTime = (String)this.avatarMap.get(username);
            if (avatarTime == null) {
                avatarTime = this.refreshUserAvatar(cmsCtx, username);
            }
            src = AVATAR_SERVLET.concat(URLEncoder.encode(username, "UTF-8")).concat("&t=").concat(avatarTime.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new CMSException((Throwable)e);
        }
        return new Link(src, false);
    }

    public String refreshUserAvatar(CMSServiceCtx cmsCtx, String username) {
        String avatarTime = Long.toString(new Date().getTime());
        this.avatarMap.put(username, avatarTime);
        return avatarTime;
    }

    public boolean isPathInLiveState(CMSServiceCtx cmsCtx, Document doc) {
        if ("1".equals(cmsCtx.getDisplayLiveVersion())) {
            return true;
        }
        return doc.getPath().equals(cmsCtx.getForcedLivePath());
    }

    public BinaryDelegation validateBinaryDelegation(CMSServiceCtx cmsCtx, String path) {
        String id = cmsCtx.getServletRequest().getSession().getId();
        Map delegationMap = (Map)delegations.get(id);
        if (delegationMap != null) {
            return (BinaryDelegation)delegationMap.get(path);
        }
        return null;
    }

    public Link getBinaryResourceURL(CMSServiceCtx cmsCtx, BinaryDescription binary) throws CMSException {
        String src = "";
        String path = "";
        boolean liveState = false;
        BinaryDelegation delegation = new BinaryDelegation();
        try {
            String binaryTimeStamp;
            String portalName = null;
            ServerInvocation invocation = cmsCtx.getServerInvocation();
            Boolean isAdmin = false;
            if (invocation != null) {
                portalName = (String)PageProperties.getProperties().getPagePropertiesMap().get("portalName");
                isAdmin = (Boolean)invocation.getAttribute(Scope.PRINCIPAL_SCOPE, (Object)"osivia.isAdmin");
            }
            if (binary.getDocument() != null) {
                Document doc = (Document)binary.getDocument();
                path = doc.getPath();
                liveState = this.isPathInLiveState(cmsCtx, doc);
                delegation.setGrantedAccess(true);
            } else {
                path = binary.getPath();
            }
            Subject subject = (Subject)PolicyContext.getContext((String)"javax.security.auth.Subject.container");
            delegation.setSubject(subject);
            delegation.setAdmin(isAdmin.booleanValue());
            if (StringUtils.endsWith((String)path, (String)".proxy") && !StringUtils.endsWith((String)path, (String)".remote.proxy")) {
                path = StringUtils.removeEnd((String)path, (String)".proxy");
            }
            delegation.setUserName(cmsCtx.getServletRequest().getRemoteUser());
            Map delegationMap = this.getUserDelegation(cmsCtx);
            delegationMap.put(path, delegation);
            boolean refresh = PageProperties.getProperties().isRefreshingPage();
            StringBuilder sb = new StringBuilder();
            sb.append(BINARY_SERVLET).append("?type=").append(binary.getType().name()).append("&path=").append(URLEncoder.encode(path, "UTF-8"));
            if (portalName != null) {
                sb.append("&portalName=").append(portalName);
            }
            if (binary.getIndex() != null) {
                sb.append("&index=").append(binary.getIndex());
            }
            if (liveState) {
                sb.append("&liveState=").append(liveState);
            }
            if (binary.getContent() != null) {
                sb.append("&content=").append(binary.getContent());
            }
            if (binary.getFieldName() != null) {
                sb.append("&fieldName=").append(binary.getFieldName());
            }
            if (binary.getFileName() != null) {
                sb.append("&fileName=").append(URLEncoder.encode(binary.getFileName(), "UTF-8"));
            }
            if (refresh) {
                sb.append("&refresh=").append(refresh);
            }
            if (cmsCtx.getScope() != null) {
                sb.append("&scope=").append(cmsCtx.getScope());
            }
            if (cmsCtx.getForcePublicationInfosScope() != null) {
                sb.append("&fscope=").append(cmsCtx.getForcePublicationInfosScope());
            }
            if ((binaryTimeStamp = (String)this.binaryMap.get(path)) == null) {
                binaryTimeStamp = this.refreshBinaryResource(cmsCtx, path);
            }
            sb.append("&t=");
            sb.append(binaryTimeStamp.toString());
            src = sb.toString();
        }
        catch (Exception e) {
            new CMSException((Throwable)e);
        }
        return new Link(src, false);
    }

    private Map<String, BinaryDelegation> getUserDelegation(CMSServiceCtx cmsCtx) {
        String id = cmsCtx.getServletRequest().getSession().getId();
        ConcurrentHashMap delegationMap = (ConcurrentHashMap)delegations.get(id);
        if (delegationMap == null) {
            delegationMap = new ConcurrentHashMap();
            delegations.put(id, delegationMap);
        }
        return delegationMap;
    }

    public void sessionDestroyed(HttpSessionEvent sessionEvent) {
        delegations.remove(sessionEvent.getSession().getId());
    }

    public void sessionCreated(HttpSessionEvent se) {
    }

    public String refreshBinaryResource(CMSServiceCtx cmsCtx, String path) {
        String pathTime = Long.toString(new Date().getTime());
        this.binaryMap.put(path, pathTime);
        return pathTime;
    }

    public IBundleFactory getBundleFactory() {
        return this.bundleFactory;
    }

    public Object executeNuxeoCommand(CMSServiceCtx cmsContext, INuxeoCommand command) throws CMSException {
        try {
            return this.cmsService.executeNuxeoCommand(cmsContext, command);
        }
        catch (CMSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CMSException((Throwable)e);
        }
    }

    public Map<String, EcmCommand> getEcmCommands() {
        HashMap<String, EcmCommand> commands = new HashMap<String, EcmCommand>();
        commands.put(EcmCommonCommands.lock.name(), (EcmCommand)new LockCommand(this.getNotificationsService(), this.getInternationalizationService()));
        commands.put(EcmCommonCommands.unlock.name(), (EcmCommand)new UnlockCommand(this.getNotificationsService(), this.getInternationalizationService()));
        commands.put(EcmCommonCommands.subscribe.name(), (EcmCommand)new SubscribeCommand(this.getNotificationsService(), this.getInternationalizationService()));
        commands.put(EcmCommonCommands.unsubscribe.name(), (EcmCommand)new UnsubscribeCommand(this.getNotificationsService(), this.getInternationalizationService()));
        commands.put(EcmCommonCommands.synchronizeFolder.name(), (EcmCommand)new SynchronizeCommand(this.getNotificationsService(), this.getInternationalizationService()));
        commands.put(EcmCommonCommands.unsynchronizeFolder.name(), (EcmCommand)new UnsynchronizeCommand(this.getNotificationsService(), this.getInternationalizationService()));
        return commands;
    }
}

