/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.portlets.list.ListCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletResponse;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.server.ServerInvocation;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.portal.core.cms.CMSException;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSServiceCtx;

public class BrowserAdapter {
    protected static final String USER_WORKSPACES_PRINCIPAL_ATTRIBUTE = "osivia.browser.userWorkspaces";
    private static BrowserAdapter instance;
    private final CMSService cmsService;

    private BrowserAdapter(CMSService cmsService) {
        this.cmsService = cmsService;
    }

    public static BrowserAdapter getInstance(CMSService cmsService) {
        if (instance == null) {
            instance = new BrowserAdapter(cmsService);
        }
        return instance;
    }

    public List<CMSItem> getWorkspaces(CMSServiceCtx cmsContext, boolean administrator) throws CMSException {
        ArrayList<Object> workspaces;
        if (administrator && !this.areWorkspacesDisplayedForAdministrator()) {
            workspaces = new ArrayList<CMSItem>(0);
        } else {
            NuxeoController nuxeoController = new NuxeoController(cmsContext.getRequest(), (PortletResponse)cmsContext.getResponse(), cmsContext.getPortletCtx());
            String query = this.getWorkspacesQuery();
            String schemas = this.getWorkspacesSchemas();
            String filter = "none";
            ListCommand nuxeoCommand = new ListCommand(query, true, 0, -1, schemas, filter, true);
            Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)nuxeoCommand);
            workspaces = new ArrayList(documents.size());
            for (Document document : documents.list()) {
                CMSItem workspace = this.cmsService.createItem(cmsContext, document.getPath(), document.getTitle(), document);
                workspaces.add(workspace);
            }
        }
        return workspaces;
    }

    public List<CMSItem> getUserWorkspaces(CMSServiceCtx cmsContext) throws CMSException {
        ArrayList<Object> workspaces;
        ServerInvocation invocation = cmsContext.getServerInvocation();
        Object attribute = invocation.getAttribute(Scope.PRINCIPAL_SCOPE, (Object)USER_WORKSPACES_PRINCIPAL_ATTRIBUTE);
        if (attribute != null && attribute instanceof List) {
            List list = (List)attribute;
            workspaces = new ArrayList<CMSItem>(list.size());
            for (Object object : list) {
                if (!(object instanceof CMSItem)) continue;
                CMSItem workspace = (CMSItem)object;
                workspaces.add(workspace);
            }
        } else {
            String userName = null;
            if (invocation.getServerContext().getClientRequest().getUserPrincipal() != null) {
                userName = invocation.getServerContext().getClientRequest().getUserPrincipal().getName();
            }
            if (userName == null) {
                workspaces = new ArrayList(0);
            } else {
                String query = this.getUserWorkspacesQuery(userName);
                String schemas = this.getWorkspacesSchemas();
                String filter = "none";
                try {
                    ListCommand nuxeoCommand = new ListCommand(query, true, 0, -1, schemas, filter, true);
                    Documents documents = (Documents)this.cmsService.executeNuxeoCommand(cmsContext, (INuxeoCommand)nuxeoCommand);
                    workspaces = new ArrayList(documents.size());
                    for (Document document : documents.list()) {
                        CMSItem workspace = this.cmsService.createItem(cmsContext, document.getPath(), document.getTitle(), document);
                        workspaces.add(workspace);
                    }
                }
                catch (CMSException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new CMSException((Throwable)e);
                }
            }
            invocation.setAttribute(Scope.PRINCIPAL_SCOPE, (Object)USER_WORKSPACES_PRINCIPAL_ATTRIBUTE, workspaces);
        }
        return workspaces;
    }

    protected boolean areWorkspacesDisplayedForAdministrator() {
        return true;
    }

    protected String getWorkspacesQuery() {
        return "ecm:primaryType = 'Workspace' AND NOT ecm:path STARTSWITH '/default-domain/UserWorkspaces/'";
    }

    protected String getUserWorkspacesQuery(String userName) {
        StringBuilder query = new StringBuilder();
        query.append("ecm:primaryType = 'Workspace' AND ecm:path STARTSWITH '/default-domain/UserWorkspaces/' AND dc:creator = '");
        query.append(userName);
        query.append("'");
        return query.toString();
    }

    protected String getWorkspacesSchemas() {
        return "dublincore";
    }
}

