/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers;

import fr.toutatice.portail.cms.nuxeo.portlets.customizer.DefaultCMSCustomizer;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationHelper;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.helpers.WebConfigurationQueryCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.service.CMSService;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.core.cms.CMSItem;
import org.osivia.portal.core.cms.CMSItemType;
import org.osivia.portal.core.cms.CMSServiceCtx;

/*
 * Exception performing whole class analysis ignored.
 */
public class CMSItemAdapter {
    private static final String NX_DC_TITLE = "dc:title";
    private static final String NX_DC_DESCRIPTION = "dc:description";
    private static final String NX_DC_CREATOR = "dc:creator";
    private static final String NX_TTC_KEYWORDS = "ttc:keywords";
    protected CMSService CMSService;
    protected DefaultCMSCustomizer customizer;
    protected PortletContext portletCtx;

    public CMSItemAdapter(PortletContext portletCtx, DefaultCMSCustomizer customizer, CMSService cmsService) {
        this.CMSService = cmsService;
        this.portletCtx = portletCtx;
        this.customizer = customizer;
    }

    public static String computeNavPath(String path) {
        String result = path;
        if (path.endsWith(".proxy")) {
            result = result.substring(0, result.length() - 6);
        }
        return result;
    }

    public static boolean docHasFacet(Document doc, String facet) {
        boolean has = false;
        PropertyList facets = doc.getFacets();
        if (facets != null) {
            List facetsList = facets.list();
            has = facetsList.contains(facet);
        }
        return has;
    }

    public void adaptItem(CMSServiceCtx ctx, CMSItem item) throws Exception {
        Document doc = (Document)item.getNativeItem();
        Map properties = item.getProperties();
        this.adaptDoc(ctx, doc, properties);
        this.adaptSEOProperties(ctx, doc, item.getMetaProperties());
    }

    public Map<String, String> adaptDocument(CMSServiceCtx ctx, Document doc) throws Exception {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.adaptDoc(ctx, doc, properties);
        return properties;
    }

    public boolean supportsOnlyPortalContextualization(CMSServiceCtx ctx, Document doc) {
        CMSItemType cmsItemType = (CMSItemType)this.customizer.getCMSItemTypes().get(doc.getType());
        return cmsItemType != null && cmsItemType.isForcePortalContextualization();
    }

    public void adaptNavigationProperties(CMSServiceCtx ctx, Document doc, Map<String, String> properties) throws Exception {
        WebConfigurationQueryCommand command;
        Documents configs;
        String domainPath = WebConfigurationHelper.getDomainPath((CMSServiceCtx)ctx);
        if (domainPath != null && (configs = WebConfigurationHelper.executeWebConfigCmd((CMSServiceCtx)ctx, (CMSService)this.CMSService, (WebConfigurationQueryCommand)(command = new WebConfigurationQueryCommand(domainPath, WebConfigurationQueryCommand.WebConfigurationType.CMS_NAVIGATION_ADAPTER)))).size() > 0) {
            for (Document config : configs) {
                String documentType = config.getProperties().getString("wconf:code");
                String urlAdapted = config.getProperties().getString("wconf:code2");
                if (!doc.getType().equals(documentType)) continue;
                String path = CMSItemAdapter.computeNavPath((String)urlAdapted);
                properties.put("navigationPath", path);
                break;
            }
        }
    }

    private void adaptSEOProperties(CMSServiceCtx ctx, Document doc, Map<String, String> properties) {
        String keywords;
        PropertyMap nxProperties = doc.getProperties();
        if (nxProperties.getString("dc:title") != null) {
            properties.put("osivia.header.title", nxProperties.getString("dc:title"));
        }
        if (StringUtils.isNotBlank((String)nxProperties.getString("dc:description"))) {
            properties.put("osivia.header.meta".concat(".description"), nxProperties.getString("dc:description"));
        }
        if (StringUtils.isNotBlank((String)nxProperties.getString("dc:creator"))) {
            properties.put("osivia.header.meta".concat(".author"), nxProperties.getString("dc:creator"));
        }
        if (nxProperties.getList("ttc:keywords") != null && StringUtils.isNotBlank((String)(keywords = StringUtils.join((Collection)nxProperties.getList("ttc:keywords").list(), (String)",")))) {
            properties.put("osivia.header.meta".concat(".keywords"), keywords);
        }
    }

    public void adaptDoc(CMSServiceCtx ctx, Document doc, Map<String, String> properties) throws Exception {
        if (this.supportsOnlyPortalContextualization(ctx, doc)) {
            properties.put("supportsOnlyPortalContextualization", "1");
        }
        this.adaptNavigationProperties(ctx, doc, properties);
    }
}

