/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.document.comments;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.document.comments.HTMLCommentsTreeBuilder;
import java.io.File;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.FileBlob;
import org.nuxeo.ecm.automation.client.model.OperationInput;

public class AddCommentCommand
implements INuxeoCommand {
    private Document document;
    private String commentContent;
    private String commentTitle;
    private File file;

    public AddCommentCommand(Document document, String commentContent, String commentTitle, File file) {
        this.document = document;
        this.commentContent = commentContent;
        this.commentTitle = commentTitle;
        this.file = file;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        boolean hasFile = this.file != null;
        OperationRequest request = nuxeoSession.newRequest("Document.AddComment");
        request.set("commentableDoc", (Object)this.document.getId());
        this.commentContent = HTMLCommentsTreeBuilder.storeNewLines((String)this.commentContent);
        request.set("comment", (Object)this.commentContent);
        request.set("title", (Object)this.commentTitle);
        if (hasFile) {
            request.set("fileName", (Object)this.file.getName());
        } else {
            this.file = File.createTempFile("tmp_com", ".tmp");
        }
        request.setInput((OperationInput)new FileBlob(this.file));
        request.execute();
        if (!hasFile) {
            this.file.delete();
        }
        return this.document;
    }

    public static void setBlob(Session nuxeoSession, String commentId, File file) throws Exception {
        DocumentService rs = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        DocRef commentRef = new DocRef(commentId);
        FileBlob blob = new FileBlob(file);
        rs.setBlob(commentRef, (Blob)blob, "post:fileContent");
    }

    public String getId() {
        return "Document.AddComment: " + this.document.getTitle();
    }
}

