/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.files;

import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoException;
import fr.toutatice.portail.cms.nuxeo.api.PortletErrorHandler;
import fr.toutatice.portail.cms.nuxeo.api.domain.DocumentDTO;
import fr.toutatice.portail.cms.nuxeo.api.services.dao.DocumentDAO;
import fr.toutatice.portail.cms.nuxeo.portlets.files.FileBrowserComparator;
import fr.toutatice.portail.cms.nuxeo.portlets.files.FileBrowserItem;
import fr.toutatice.portail.cms.nuxeo.portlets.files.FileBrowserSortCriteria;
import fr.toutatice.portail.cms.nuxeo.portlets.files.GetFolderFilesCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.files.MoveDocumentCommand;
import fr.toutatice.portail.cms.nuxeo.portlets.files.UploadFilesCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.activation.MimeType;
import javax.activation.MimeTypeParseException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderMode;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.WindowState;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.portlet.PortletFileUpload;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.jboss.portal.common.invocation.Scope;
import org.jboss.portal.core.controller.ControllerContext;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.internationalization.IInternationalizationService;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.Notifications;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.osivia.portal.core.cms.CMSItemType;
import org.osivia.portal.core.cms.CMSPublicationInfos;
import org.osivia.portal.core.cms.CMSServiceCtx;
import org.osivia.portal.core.cms.ICMSService;

public class FileBrowserPortlet
extends CMSPortlet {
    private static final int FILE_UPLOAD_NOTIFICATIONS_DURATION = 1000;
    private static final String NUXEO_PATH_WINDOW_PROPERTY = "osivia.nuxeoPath";
    private static final String SORT_CRITERIA_REQUEST_PARAMETER = "sort";
    private static final String ALTERNATIVE_SORT_REQUEST_PARAMETER = "alt";
    private static final String SORT_CRITERIA_PRINCIPAL_ATTRIBUTE = "osivia.fileBrowser.sortCriteria";
    private static final String PATH_ADMIN = "/WEB-INF/jsp/files/admin.jsp";
    private static final String PATH_VIEW = "/WEB-INF/jsp/files/view.jsp";
    private static final String PATH_ERROR = "/WEB-INF/jsp/files/error.jsp";
    private IBundleFactory bundleFactory;
    private INotificationsService notificationsService;
    private DocumentDAO documentDAO;

    public void init(PortletConfig config) throws PortletException {
        super.init(config);
        PortletContext portletContext = this.getPortletContext();
        IInternationalizationService internationalizationService = (IInternationalizationService)portletContext.getAttribute("InternationalizationService");
        this.bundleFactory = internationalizationService.getBundleFactory(this.getClass().getClassLoader());
        this.notificationsService = (INotificationsService)portletContext.getAttribute("NotificationsService");
        this.documentDAO = DocumentDAO.getInstance();
    }

    public void processAction(ActionRequest request, ActionResponse response) throws PortletException, IOException {
        String action = request.getParameter("javax.portlet.action");
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
        PortalControllerContext portalControllerContext = nuxeoController.getPortalCtx();
        Bundle bundle = this.bundleFactory.getBundle(request.getLocale());
        if (PortletMode.VIEW.equals((Object)request.getPortletMode())) {
            if ("drop".equals(action)) {
                String sourceId = request.getParameter("sourceId");
                String targetId = request.getParameter("targetId");
                MoveDocumentCommand command = new MoveDocumentCommand(sourceId, targetId);
                try {
                    nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                    request.setAttribute("osivia.updateContents", (Object)"true");
                    response.setRenderParameter("dnd-update", String.valueOf(System.currentTimeMillis()));
                    String message = bundle.getString("MESSAGE_MOVE_SUCCESS");
                    this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.SUCCESS);
                }
                catch (NuxeoException e) {
                    String message = bundle.getString("MESSAGE_MOVE_ERROR");
                    this.notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.ERROR);
                }
            } else if ("fileUpload".equals(action)) {
                Notifications notifications;
                String parentId = request.getParameter("parentId");
                try {
                    DiskFileItemFactory fileItemFactory = new DiskFileItemFactory();
                    PortletFileUpload fileUpload = new PortletFileUpload((FileItemFactory)fileItemFactory);
                    List fileItems = fileUpload.parseRequest(request);
                    UploadFilesCommand command = new UploadFilesCommand(parentId, fileItems);
                    nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                    request.setAttribute("osivia.updateContents", (Object)"true");
                    notifications = new Notifications(NotificationsType.SUCCESS, 1000);
                    notifications.addMessage(bundle.getString("MESSAGE_FILE_UPLOAD_SUCCESS"));
                }
                catch (FileUploadException e) {
                    notifications = new Notifications(NotificationsType.ERROR, 1000);
                    notifications.addMessage(bundle.getString("MESSAGE_FILE_UPLOAD_ERROR"));
                }
                this.notificationsService.addNotifications(portalControllerContext, notifications);
            }
        } else if ("admin".equals(request.getPortletMode().toString())) {
            if ("save".equals(action)) {
                PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
                String path = request.getParameter("path");
                window.setProperty(NUXEO_PATH_WINDOW_PROPERTY, path);
            }
            response.setPortletMode(PortletMode.VIEW);
            response.setWindowState(WindowState.NORMAL);
        }
    }

    @RenderMode(name="admin")
    public void doAdmin(RenderRequest request, RenderResponse response) throws IOException, PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty(NUXEO_PATH_WINDOW_PROPERTY);
        request.setAttribute("path", (Object)path);
        response.setContentType("text/html");
        this.getPortletContext().getRequestDispatcher(PATH_ADMIN).include(request, response);
    }

    protected void doView(RenderRequest request, RenderResponse response) throws PortletException, IOException {
        PortletRequestDispatcher dispatcher;
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String path = window.getProperty("osivia.cms.uri");
        if (path == null) {
            path = window.getProperty(NUXEO_PATH_WINDOW_PROPERTY);
        }
        if (StringUtils.isNotEmpty((String)path)) {
            try {
                FileBrowserSortCriteria criteria;
                ControllerContext controllerContext = (ControllerContext)request.getAttribute("osivia.controller");
                NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, this.getPortletContext());
                request.setAttribute("nuxeoController", (Object)nuxeoController);
                ICMSService cmsService = NuxeoController.getCMSService();
                CMSServiceCtx cmsContext = nuxeoController.getCMSCtx();
                path = nuxeoController.getComputedPath(path);
                Document currentDocument = nuxeoController.fetchDocument(path);
                nuxeoController.setCurrentDoc(currentDocument);
                request.setAttribute("document", (Object)this.documentDAO.toDTO(currentDocument));
                CMSPublicationInfos publicationInfos = cmsService.getPublicationInfos(cmsContext, path);
                boolean editable = publicationInfos.isEditableByUser();
                request.setAttribute("editable", (Object)editable);
                GetFolderFilesCommand command = new GetFolderFilesCommand(publicationInfos.getLiveId());
                Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
                int index = 1;
                ArrayList<FileBrowserItem> fileBrowserItems = new ArrayList<FileBrowserItem>(documents.size());
                for (Document document : documents) {
                    DocumentDTO documentDTO = this.documentDAO.toDTO(document);
                    FileBrowserItem fileBrowserItem = new FileBrowserItem(documentDTO);
                    fileBrowserItem.setIndex(index++);
                    if ("File".equals(document.getType())) {
                        this.addMimeType(document, (DocumentDTO)fileBrowserItem);
                    }
                    fileBrowserItems.add(fileBrowserItem);
                }
                CMSItemType cmsItemType = (CMSItemType)nuxeoController.getCMSItemTypes().get(currentDocument.getType());
                boolean ordered = cmsItemType != null && cmsItemType.isOrdered();
                request.setAttribute("ordered", (Object)ordered);
                String sort = request.getParameter(SORT_CRITERIA_REQUEST_PARAMETER);
                if (StringUtils.isEmpty((String)sort)) {
                    Object attribute = controllerContext.getAttribute(Scope.PRINCIPAL_SCOPE, (Object)SORT_CRITERIA_PRINCIPAL_ATTRIBUTE);
                    if (attribute != null && attribute instanceof FileBrowserSortCriteria) {
                        criteria = (FileBrowserSortCriteria)controllerContext.getAttribute(Scope.PRINCIPAL_SCOPE, (Object)SORT_CRITERIA_PRINCIPAL_ATTRIBUTE);
                    } else {
                        criteria = new FileBrowserSortCriteria();
                        if (ordered) {
                            criteria.setSort("index");
                        } else {
                            criteria.setSort("name");
                        }
                        controllerContext.setAttribute(Scope.PRINCIPAL_SCOPE, (Object)SORT_CRITERIA_PRINCIPAL_ATTRIBUTE, (Object)criteria);
                    }
                } else {
                    boolean alternative = BooleanUtils.toBoolean((String)request.getParameter(ALTERNATIVE_SORT_REQUEST_PARAMETER));
                    criteria = new FileBrowserSortCriteria();
                    criteria.setSort(sort);
                    criteria.setAlternative(alternative);
                    controllerContext.setAttribute(Scope.PRINCIPAL_SCOPE, (Object)SORT_CRITERIA_PRINCIPAL_ATTRIBUTE, (Object)criteria);
                }
                request.setAttribute("criteria", (Object)criteria);
                FileBrowserComparator comparator = new FileBrowserComparator(criteria);
                Collections.sort(fileBrowserItems, comparator);
                request.setAttribute("documents", fileBrowserItems);
                response.setTitle(currentDocument.getTitle());
                if (WindowState.MAXIMIZED.equals((Object)request.getWindowState())) {
                    nuxeoController.insertContentMenuBarItems();
                }
            }
            catch (NuxeoException e) {
                PortletErrorHandler.handleGenericErrors((RenderResponse)response, (NuxeoException)e);
            }
            catch (Exception e) {
                throw new PortletException((Throwable)e);
            }
            dispatcher = this.getPortletContext().getRequestDispatcher(PATH_VIEW);
        } else {
            dispatcher = this.getPortletContext().getRequestDispatcher(PATH_ERROR);
        }
        response.setContentType("text/html");
        dispatcher.include(request, response);
    }

    private void addMimeType(Document document, DocumentDTO documentDTO) {
        String icon = "file";
        PropertyMap fileContent = document.getProperties().getMap("file:content");
        if (fileContent != null) {
            try {
                MimeType mimeType = new MimeType(fileContent.getString("mime-type"));
                String primaryType = mimeType.getPrimaryType();
                String subType = mimeType.getSubType();
                if ("application".equals(primaryType)) {
                    if ("pdf".equals(subType)) {
                        icon = "pdf";
                    } else if ("msword".equals(subType) || "vnd.openxmlformats-officedocument.wordprocessingml.document".equals(subType)) {
                        icon = "word";
                    } else if ("vnd.ms-excel".equals(subType) || "vnd.openxmlformats-officedocument.spreadsheetml.sheet".equals(subType)) {
                        icon = "excel";
                    } else if ("vnd.ms-powerpoint".equals(subType) || "vnd.openxmlformats-officedocument.presentationml.presentation".equals(subType)) {
                        icon = "powerpoint";
                    } else if ("vnd.oasis.opendocument.text".equals(subType)) {
                        icon = "odt";
                    } else if ("vnd.oasis.opendocument.spreadsheet".equals(subType)) {
                        icon = "ods";
                    } else if ("vnd.oasis.opendocument.presentation".equals(subType)) {
                        icon = "odp";
                    } else if ("zip".equals(subType) || "gzip".equals(subType)) {
                        icon = "archive";
                    }
                } else if ("text".equals(primaryType)) {
                    icon = "html".equals(subType) || "xml".equals(subType) ? "xml" : "text";
                } else if ("image".equals(primaryType)) {
                    icon = "image";
                } else if ("video".equals(primaryType)) {
                    icon = "video";
                } else if ("audio".equals(primaryType)) {
                    icon = "audio";
                }
            }
            catch (MimeTypeParseException e) {
                // empty catch block
            }
        }
        documentDTO.getProperties().put("mimeTypeIcon", icon);
    }
}

