/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.fragment;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.domain.IFragmentModule;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.urls.Link;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;

public class ZoomFragmentModule
implements IFragmentModule {
    public static final String ID = "zoom_property";
    public static final String NUXEO_PATH_WINDOW_PROPERTY = "osivia.cms.uri";
    public static final String SCOPE_WINDOW_PROPERTY = "osivia.cms.forcePublicationScope";
    public static final String REF_URI_WINDOW_PROPERTY = "osivia.refURI";
    private static final String VIEW_JSP_NAME = "zoom";
    private static final String REF_URI = "refURI";
    private static final String HREF = "href";
    private static final String CONTENT = "content";
    private static final String PICTURE = "picture";
    private static final String TEMPLATE = "zoomTemplate";
    private static IFragmentModule instance;

    private ZoomFragmentModule() {
    }

    public static IFragmentModule getInstance() {
        if (instance == null) {
            instance = new ZoomFragmentModule();
        }
        return instance;
    }

    public void doView(PortalControllerContext portalControllerContext) throws PortletException {
        RenderRequest request = (RenderRequest)portalControllerContext.getRequest();
        RenderResponse response = (RenderResponse)portalControllerContext.getResponse();
        NuxeoController nuxeoController = new NuxeoController((PortletRequest)request, (PortletResponse)response, portalControllerContext.getPortletCtx());
        PortalWindow window = WindowFactory.getWindow((PortletRequest)request);
        String nuxeoPath = window.getProperty(NUXEO_PATH_WINDOW_PROPERTY);
        boolean emptyContent = true;
        if (StringUtils.isNotEmpty((String)nuxeoPath)) {
            PropertyList propertyList;
            Object content;
            String refURI;
            String schema;
            Document document = nuxeoController.fetchDocument(nuxeoPath = nuxeoController.getComputedPath(nuxeoPath));
            if (document.getTitle() != null) {
                response.setTitle(document.getTitle());
            }
            if (StringUtils.isNotEmpty((String)(schema = "zfgt:zoomFragment")) && StringUtils.isNotEmpty((String)(refURI = window.getProperty(REF_URI_WINDOW_PROPERTY))) && (content = document.getProperties().get(schema)) instanceof PropertyList && (propertyList = (PropertyList)content) != null && propertyList.size() > 0) {
                for (int index = 0; index < propertyList.size(); ++index) {
                    PropertyMap propertyMap = propertyList.getMap(index);
                    String refURIValue = (String)propertyMap.get(REF_URI);
                    if (!refURI.equalsIgnoreCase(refURIValue)) continue;
                    request.setAttribute("template", (Object)propertyMap.getString(TEMPLATE));
                    request.setAttribute("title", (Object)window.getProperty("osivia.title"));
                    String href = propertyMap.getString(HREF);
                    Link link = nuxeoController.getLinkFromNuxeoURL(href);
                    request.setAttribute("url", (Object)link.getUrl());
                    String imageSource = null;
                    if (StringUtils.isNotBlank((String)propertyMap.getString(PICTURE))) {
                        imageSource = nuxeoController.createAttachedPictureLink(nuxeoPath, propertyMap.getString(PICTURE));
                    }
                    request.setAttribute("imageSource", imageSource);
                    request.setAttribute(CONTENT, (Object)nuxeoController.transformHTMLContent(StringUtils.trimToEmpty((String)propertyMap.getString(CONTENT))));
                    emptyContent = false;
                }
            }
        }
        if (emptyContent) {
            request.setAttribute("osivia.emptyResponse", (Object)"1");
        }
    }

    public void doAdmin(PortalControllerContext portalControllerContext) throws PortletException {
    }

    public void processAdminAction(PortalControllerContext portalControllerContext) throws PortletException {
    }

    public boolean isDisplayedInAdmin() {
        return false;
    }

    public String getViewJSPName() {
        return VIEW_JSP_NAME;
    }

    public String getAdminJSPName() {
        return null;
    }
}

