/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.list;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

public class ListCommand
implements INuxeoCommand {
    String nuxeoRequest;
    int pageNumber;
    int pageSize;
    String schemas;
    boolean displayLiveVersion;
    String portalPolicyFilter;
    boolean useES;

    public ListCommand(String nuxeoRequest, boolean displayLiveVersion, int pageNumber, int pageSize, String schemas, String portalPolicyFilter, boolean useES) {
        this.nuxeoRequest = nuxeoRequest;
        this.displayLiveVersion = displayLiveVersion;
        this.pageNumber = pageNumber;
        this.pageSize = pageSize;
        this.schemas = schemas;
        this.portalPolicyFilter = portalPolicyFilter;
        this.useES = NuxeoCompatibility.canUseES() && useES;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        OperationRequest request = this.useES ? this.generateESRequest(nuxeoSession) : this.generateVCSRequest(nuxeoSession);
        NuxeoQueryFilterContext queryFilter = new NuxeoQueryFilterContext(this.displayLiveVersion ? 1 : 0, this.portalPolicyFilter);
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)queryFilter, (String)this.nuxeoRequest);
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredRequest));
        return request.execute();
    }

    protected OperationRequest generateESRequest(Session session) throws Exception {
        OperationRequest request = session.newRequest("Document.QueryES");
        request.set("pageSize", (Object)this.pageSize);
        request.set("currentPageIndex", (Object)this.pageNumber);
        request.set("X-NXDocumentProperties", (Object)this.schemas);
        return request;
    }

    protected OperationRequest generateVCSRequest(Session session) throws Exception {
        OperationRequest request = session.newRequest("Document.PageProvider");
        request.set("pageSize", (Object)this.pageSize);
        request.set("page", (Object)this.pageNumber);
        request.setHeader("X-NXDocumentProperties", this.schemas);
        if (NuxeoCompatibility.isVersionGreaterOrEqualsThan((int)NuxeoCompatibility.VERSION_60)) {
            request.set("maxResults", (Object)"-1");
        }
        return request;
    }

    public String getId() {
        return "ListCommand/" + this.displayLiveVersion + "/" + this.pageSize + "/" + this.pageNumber + "/" + this.nuxeoRequest;
    }
}

