/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.portlets.search;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoCompatibility;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import fr.toutatice.portail.cms.nuxeo.portlets.customizer.CMSCustomizer;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.PaginableDocuments;

public class SearchCommand
implements INuxeoCommand {
    String path;
    String keywords;
    int pageNumber;
    NuxeoQueryFilterContext queryCtx;

    public SearchCommand(NuxeoQueryFilterContext queryCtx, String path, String keywords, int pageNumber) {
        this.queryCtx = queryCtx;
        this.path = path;
        this.keywords = keywords;
        this.pageNumber = pageNumber;
    }

    private String addClause(String request, String clause) {
        String result = request;
        result = request.length() == 0 ? "WHERE " : result + " AND ";
        result = result + clause;
        return result;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        String searchKeywords;
        OperationRequest request = NuxeoCompatibility.canUseES() ? this.generateESRequest(nuxeoSession) : this.generateVCSRequest(nuxeoSession);
        String searchQuery = "";
        if (this.path != null && this.path.length() > 0) {
            searchQuery = this.addClause(searchQuery, "ecm:path STARTSWITH '" + this.path + "'");
        }
        if ((searchKeywords = this.keywords) == null) {
            searchKeywords = "";
        }
        searchKeywords = searchKeywords + " -noindex";
        searchQuery = this.addClause(searchQuery, "ecm:fulltext = '" + searchKeywords + "'");
        String filteredRequest = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)this.queryCtx, (String)searchQuery);
        request.set("query", (Object)("SELECT * FROM Document " + filteredRequest));
        PaginableDocuments result = (PaginableDocuments)request.execute();
        return result;
    }

    protected OperationRequest generateESRequest(Session session) throws Exception {
        OperationRequest request = session.newRequest("Document.QueryES");
        request.set("pageSize", (Object)5);
        request.set("currentPageIndex", (Object)this.pageNumber);
        request.set("X-NXDocumentProperties", (Object)CMSCustomizer.getSearchSchema());
        return request;
    }

    protected OperationRequest generateVCSRequest(Session session) throws Exception {
        OperationRequest request = session.newRequest("Document.PageProvider");
        request.set("pageSize", (Object)5);
        request.set("page", (Object)this.pageNumber);
        request.setHeader("X-NXDocumentProperties", CMSCustomizer.getSearchSchema());
        if (NuxeoCompatibility.isVersionGreaterOrEqualsThan((int)NuxeoCompatibility.VERSION_60)) {
            request.set("maxResults", (Object)"-1");
        }
        return request;
    }

    public String getId() {
        return "SearchCommand" + this.path + "/" + this.keywords;
    }
}

